/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.bean.velocity;

import com.codestudio.sql.PoolMan;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.SQLManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.servlet.VelocityServlet;

public class PoolManVelocityServlet
extends VelocityServlet {
    public static final String SQL_QUERY = "sql";
    public static final String CURRENT_DATABASE = "currentDatabaseName";
    public static final String ALL_DB_NAMES = "allDatabaseNames";
    public static final String HEADER_COLS = "headerColumns";
    public static final String RESULTS_ROWS = "resultsRows";
    public static final String ERRORS = "errors";
    public static final String QUERY_COUNT = "queryCount";
    public static final String QUERY_DURATION = "lastQueryDuration";
    public static final String USING_CACHE = "usingCache";
    public static final String DB_URL = "url";
    public static final String DB_DRIVER = "driver";
    public static final String DB_USER = "user";
    public static final String TOTAL_CONS = "totalConnections";
    public static final String AVAIL_CONS = "availableConnections";
    public static final String UNAVAIL_CONS = "unavailableConnections";

    protected Properties loadConfiguration(ServletConfig servletConfig) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        String string = servletConfig.getServletContext().getRealPath("/");
        if (string == null) {
            System.out.println(" com.codestudio.bean.velocity.PoolManVelocityServlet.loadConfiguration(): unable to get the current webapp root.  Using '/'. Please fix.");
            string = "/";
        }
        properties.setProperty("file.resource.loader.path", string);
        properties.setProperty("runtime.log", string + "velocity.log");
        return properties;
    }

    public Template handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Context context) {
        String string;
        if (this.inspectRequest(context, httpServletRequest)) {
            try {
                this.executeSQL(context);
            }
            catch (SQLException sQLException) {
                context.put(ERRORS, (Object)sQLException.toString());
            }
        }
        try {
            string = (String)context.get(CURRENT_DATABASE);
            JDBCPool jDBCPool = (JDBCPool)SQLManager.getInstance().getPool(string);
            context.put(TOTAL_CONS, (Object)("" + jDBCPool.numTotalObjects()));
            context.put(AVAIL_CONS, (Object)("" + jDBCPool.numCheckedInObjects()));
            context.put(UNAVAIL_CONS, (Object)("" + jDBCPool.numCheckedOutObjects()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = null;
        try {
            string = this.getTemplate("poolman-velocity.vm");
        }
        catch (ParseErrorException parseErrorException) {
            System.out.println("com.codestudio.bean.velocity.PoolManVelocityServlet : parse error for template " + (Object)((Object)parseErrorException));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            System.out.println("com.codestudio.bean.velocity.PoolManVelocityServlet : template not found " + (Object)((Object)resourceNotFoundException));
        }
        catch (Exception exception) {
            System.out.println("Error " + exception);
        }
        return string;
    }

    protected boolean inspectRequest(Context context, HttpServletRequest httpServletRequest) {
        Object object;
        Object object2;
        boolean bl = false;
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)context.get(ALL_DB_NAMES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList == null || arrayList.size() < 1) {
            arrayList = new ArrayList();
            object2 = SQLManager.getInstance().getAllPoolnames();
            while (object2.hasMoreElements()) {
                arrayList.add(object2.nextElement());
            }
            if (arrayList.size() < 1) {
                arrayList = null;
            }
        }
        context.put(ALL_DB_NAMES, arrayList);
        object2 = null;
        try {
            object2 = httpServletRequest.getParameter(CURRENT_DATABASE);
            context.put(CURRENT_DATABASE, object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object2 != null) {
            object = (JDBCPool)SQLManager.getInstance().getPool((String)object2);
            if (((JDBCPool)object).usingCache()) {
                context.put(USING_CACHE, (Object)"true");
            } else {
                context.put(USING_CACHE, (Object)"false");
            }
            context.put(DB_URL, (Object)((JDBCPool)object).getURL());
            context.put(DB_DRIVER, (Object)((JDBCPool)object).getDriver());
            context.put(DB_USER, (Object)((JDBCPool)object).getUserName());
        }
        object = null;
        try {
            object = httpServletRequest.getParameter(SQL_QUERY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null && ((String)object).length() > 0) {
            context.put(SQL_QUERY, object);
        } else {
            context.put(SQL_QUERY, (Object)"");
        }
        bl = object2 != null && object != null && ((String)object).length() > 0;
        return bl;
    }

    protected void executeSQL(Context context) throws SQLException {
        context.put(ERRORS, null);
        context.put(HEADER_COLS, null);
        context.put(RESULTS_ROWS, null);
        String string = (String)context.get(CURRENT_DATABASE);
        String string2 = (String)context.get(SQL_QUERY);
        DataSource dataSource = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            int n2 = Integer.parseInt((String)context.get(QUERY_COUNT));
            if (n2 > n) {
                n = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        context.put(QUERY_COUNT, (Object)("" + ++n));
        try {
            long l = System.currentTimeMillis();
            dataSource = PoolMan.findDataSource(string);
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            ArrayList arrayList = new ArrayList();
            if (statement.execute(string2)) {
                context.put(QUERY_DURATION, (Object)("" + (System.currentTimeMillis() - l)));
                resultSet = statement.getResultSet();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n3 = 1;
                while (n3 <= resultSetMetaData.getColumnCount()) {
                    arrayList2.add(resultSetMetaData.getColumnLabel(n3));
                    ++n3;
                }
                context.put(HEADER_COLS, arrayList2);
                while (resultSet.next()) {
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    int n4 = 1;
                    while (n4 <= resultSetMetaData.getColumnCount()) {
                        Object object = null;
                        try {
                            switch (resultSetMetaData.getColumnType(n4)) {
                                case 1: {
                                    try {
                                        object = new String(resultSet.getBytes(n4));
                                    }
                                    catch (Exception exception) {
                                        object = resultSet.getObject(n4);
                                    }
                                    break;
                                }
                                default: {
                                    object = resultSet.getObject(n4);
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object == null) {
                            object = new String("NULL");
                        }
                        arrayList3.add(object);
                        ++n4;
                    }
                    arrayList.add(arrayList3);
                }
            } else {
                context.put(QUERY_DURATION, (Object)("" + (System.currentTimeMillis() - l)));
                String string3 = null;
                int n5 = statement.getUpdateCount();
                switch (n5) {
                    case 0: {
                        string3 = "No rows affected";
                        break;
                    }
                    case 1: {
                        string3 = "1 row affected";
                        break;
                    }
                    default: {
                        string3 = n5 + " rows affected";
                    }
                }
                ArrayList<String> arrayList4 = new ArrayList<String>();
                arrayList4.add(string3);
                arrayList.add(arrayList4);
            }
            context.put(RESULTS_ROWS, arrayList);
            Object var20_26 = null;
        }
        catch (Throwable throwable) {
            Object var20_27 = null;
            JDBCPool.closeResources(connection, statement, resultSet);
            throw throwable;
        }
        JDBCPool.closeResources(connection, statement, resultSet);
    }
}

