/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestErrorHandler
implements ErrorHandler {
    private PrintWriter out;

    public TestErrorHandler() {
        this.out = new PrintWriter(System.err);
    }

    public TestErrorHandler(OutputStream aOut) {
        this.out = new PrintWriter(aOut);
    }

    @Override
    public void error(SAXParseException aException) throws SAXException {
        String str = this.getErrorString("Error", aException);
        this.out.println(str);
        throw new SAXException(str);
    }

    @Override
    public void warning(SAXParseException aException) throws SAXException {
        String str = this.getErrorString("Warning", aException);
        this.out.println(str);
        throw new SAXException(str);
    }

    @Override
    public void fatalError(SAXParseException aException) throws SAXException {
        String str = this.getErrorString("Fatal Error", aException);
        this.out.println(str);
        throw new SAXException(str);
    }

    public String getErrorString(String aLevel, SAXParseException aException) {
        StringBuffer ret = new StringBuffer();
        ret.append("Level      : " + aLevel);
        String systemId = aException.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            ret.append(systemId);
        }
        ret.append("\nLine    : " + aException.getLineNumber());
        ret.append("\nColumn  : " + aException.getColumnNumber());
        ret.append("\nMessage : " + aException.getMessage());
        return ret.toString();
    }
}

