/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.server;

import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPServerCon;
import com.verisign.epp.transport.EPPServerThread;
import com.verisign.epp.transport.ServerEventHandler;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import java.io.IOException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSSLServer
implements EPPServerCon {
    private static Logger cat = Logger.getLogger((String)EPPSSLServer.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private SSLServerSocket serverSocket = null;
    private boolean listening = true;
    private ServerEventHandler handler = null;
    private int portNumber = 0;
    private SSLServerSocketFactory serverSocketFactory = null;

    protected String getSSLPropertyListString(String[] aList) {
        if (aList == null) {
            return null;
        }
        String theStr = "";
        for (int i = 0; i < aList.length; ++i) {
            if (i > 0) {
                theStr = theStr + " ";
            }
            theStr = theStr + aList[i];
        }
        return theStr;
    }

    public EPPSSLServer() throws EPPConException {
        cat.debug((Object)"EPPSSLServer.EPPSSLServer(): entering Constructor");
        if (!EPPSSLImpl.isInitialized()) {
            cat.info((Object)"EPPSSLServer.EPPSSLServer(): Initializing server SSL configuration");
            EPPSSLImpl.initialize();
            cat.info((Object)"EPPSSLServer.EPPSSLServer(): server SSL configuration complete");
        } else {
            cat.debug((Object)"EPPSSLServer.EPPSSLServer(): server SSL configuration already done");
        }
        this.serverSocketFactory = EPPSSLImpl.getSSLContext().getServerSocketFactory();
        try {
            this.portNumber = EPPEnv.getServerPort();
        }
        catch (EPPEnvException myException) {
            cat.error((Object)("Connection Failed Due to : " + myException.getMessage()), (Throwable)myException);
            throw new EPPConException("Connection Failed Due to : " + myException.getMessage());
        }
        cat.debug((Object)("EPPSSLServer.EPPSSLServer(): ServerPort = " + this.portNumber));
        cat.debug((Object)"EPPSSLServer.EPPSSLServer(): entering Constructor");
    }

    @Override
    public void RunServer(ServerEventHandler aHandler) throws EPPConException {
        cat.debug((Object)"EPPSSLServer.RunServer(): entering Method");
        try {
            this.serverSocket = (SSLServerSocket)this.serverSocketFactory.createServerSocket(this.portNumber);
        }
        catch (IOException myException) {
            cat.error((Object)("Could not Create a ServerSocket " + myException.getMessage()), (Throwable)myException);
            throw new EPPConException("Could not Create a ServerSocket " + myException.getMessage());
        }
        EPPSSLContext eppSSLContext = EPPSSLImpl.getEPPSSLContext();
        if (eppSSLContext.hasSSLEnabledProtocols()) {
            cat.debug((Object)("EPPSSLServer.RunServer(): Enabled Protocols = [" + this.getSSLPropertyListString(eppSSLContext.getSSLEnabledProtocols()) + "]"));
            this.serverSocket.setEnabledProtocols(eppSSLContext.getSSLEnabledProtocols());
        } else {
            cat.debug((Object)"EPPSSLServer.RunServer(): Enabled Protocols NOT specified, using providers default");
        }
        if (eppSSLContext.hasSSLEnabledCipherSuites()) {
            cat.debug((Object)("EPPSSLServer.RunServer(): Enabled Cipher Suites = [" + this.getSSLPropertyListString(eppSSLContext.getSSLEnabledCipherSuites()) + "]"));
            this.serverSocket.setEnabledCipherSuites(eppSSLContext.getSSLEnabledCipherSuites());
        } else {
            cat.debug((Object)"EPPSSLServer.RunServer(): Enabled Cipher Suites NOT specified, using providers default");
        }
        this.serverSocket.setNeedClientAuth(true);
        this.handler = aHandler;
        this.loop();
        this.close();
        cat.debug((Object)"EPPSSLServer.RunServer(): Exiting Method");
    }

    public void loop() throws EPPConException {
        cat.debug((Object)"EPPSSLServer.loop(): Entering Method");
        try {
            while (this.listening) {
                EPPServerThread p = new EPPServerThread(this.serverSocket.accept(), this.handler);
                p.start();
            }
        }
        catch (IOException myException) {
            throw new EPPConException("I/O Error occured when wating for connection");
        }
        catch (SecurityException myException) {
            cat.error((Object)"security Manger exists and its checkListen method doesn't allow accpet operation", (Throwable)myException);
            throw new EPPConException("security Manger exists and its checkListen method doesn't allow accpet operation");
        }
        cat.debug((Object)"EPPSSLServer.loop(): Exting Method");
    }

    public void close() throws EPPConException {
        cat.debug((Object)"EPPSSLServer.close(): Entering Method");
        try {
            this.serverSocket.close();
        }
        catch (IOException myException) {
            cat.error((Object)("Close on Server socket Failed" + myException.getMessage()), (Throwable)myException);
            throw new EPPConException("Close on Server socket Failed" + myException.getMessage());
        }
        cat.debug((Object)"EPPSSLServer.close(): Exting Method");
    }

    public boolean isListening() {
        return this.listening;
    }

    public void setListening(boolean aListening) {
        this.listening = aListening;
    }
}

