/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckDomain;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckResp;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckTable;
import com.verisign.epp.codec.idntable.EPPIdnTableDomainLabel;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoDomain;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoDomainTable;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoListItem;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoResp;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoTable;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPIdnTableHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class IdnTableHandler
extends EPPIdnTableHandler {
    private static Logger cat = Logger.getLogger((String)IdnTableHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doIdnTableCheck(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doIdnTableCheck: enter");
        EPPIdnTableCheckCmd theCommand = (EPPIdnTableCheckCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPIdnTableCheckResp theResp = new EPPIdnTableCheckResp(theTransId);
        switch (theCommand.getForm()) {
            case DOMAIN_FORM: {
                cat.debug((Object)"doIdnTableCheck: Command with domain form.");
                List<EPPIdnTableDomainLabel> theDomains = theCommand.getDomains();
                for (EPPIdnTableDomainLabel theDomainLabel : theDomains) {
                    EPPIdnTableCheckDomain theCheckDomain;
                    if (theDomainLabel.getDomain().equalsIgnoreCase("idn1.example")) {
                        theCheckDomain = new EPPIdnTableCheckDomain("idn1.example", true, true);
                        theCheckDomain.addTable("CHI");
                        theResp.addDomain(theCheckDomain);
                        continue;
                    }
                    if (theDomainLabel.getDomain().equalsIgnoreCase("idn2.example")) {
                        theCheckDomain = new EPPIdnTableCheckDomain("idn2.example", true, true);
                        theCheckDomain.setIdnmap(true);
                        theCheckDomain.addTable("CHI");
                        theCheckDomain.addTable("JPN");
                        theResp.addDomain(theCheckDomain);
                        continue;
                    }
                    if (theDomainLabel.getDomain().equalsIgnoreCase("idn3.example")) {
                        theCheckDomain = new EPPIdnTableCheckDomain("idn3.example", "Commingled scripts");
                        theResp.addDomain(theCheckDomain);
                        continue;
                    }
                    theCheckDomain = new EPPIdnTableCheckDomain(theDomainLabel.getDomain(), true, false);
                    theResp.addDomain(theCheckDomain);
                }
                break;
            }
            case TABLE_FORM: {
                cat.debug((Object)"doIdnTableCheck: Command with table form.");
                List<String> theTables = theCommand.getTables();
                for (String theTableName : theTables) {
                    if (theTableName.equalsIgnoreCase("CHI")) {
                        theResp.addTable(new EPPIdnTableCheckTable("CHI", true));
                        continue;
                    }
                    if (theTableName.equalsIgnoreCase("JPN")) {
                        theResp.addTable(new EPPIdnTableCheckTable("JPN", true));
                        continue;
                    }
                    if (theTableName.equalsIgnoreCase("INVALID")) {
                        theResp.addTable(new EPPIdnTableCheckTable("INVALID", false));
                        continue;
                    }
                    theResp.addTable(new EPPIdnTableCheckTable(theTableName, false));
                }
                break;
            }
            case UNDEFINED_FORM: {
                cat.error((Object)"doIdnTableCheck: Command with undefined form.");
                EPPResponse theErrorResponse = new EPPResponse(theTransId);
                theErrorResponse.setResult(2306);
                theErrorResponse.getResult().addExtValueReason("IDN Table Check using undefined form");
                return new EPPEventResponse(theErrorResponse);
            }
        }
        cat.debug((Object)"doIdnTableCheck: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doIdnTableInfo(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doIdnTableInfo: enter");
        EPPIdnTableInfoCmd theCommand = (EPPIdnTableInfoCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPIdnTableInfoResp theResp = new EPPIdnTableInfoResp(theTransId);
        switch (theCommand.getForm()) {
            case DOMAIN_FORM: {
                cat.debug((Object)"doIdnTableInfo: Command with domain form.");
                if (theCommand.getDomain().equalsIgnoreCase("idn1.example")) {
                    EPPIdnTableInfoDomain theDomain = new EPPIdnTableInfoDomain("idn1.example", true);
                    theDomain.addTable(new EPPIdnTableInfoDomainTable("THAI", EPPIdnTableInfoDomainTable.Type.SCRIPT, "THAI", "en", false));
                    theResp.setDomain(theDomain);
                    break;
                }
                if (theCommand.getDomain().equalsIgnoreCase("xn--idn1.example")) {
                    EPPIdnTableInfoDomain theDomain = new EPPIdnTableInfoDomain("xn--idn1.example", true);
                    theDomain.setIdnmap(true);
                    theDomain.setUname("idn1.example");
                    theDomain.addTable(new EPPIdnTableInfoDomainTable("CHI", EPPIdnTableInfoDomainTable.Type.LANGUAGE, "Chinese (CHI)", "en", true));
                    theDomain.addTable(new EPPIdnTableInfoDomainTable("JPN", EPPIdnTableInfoDomainTable.Type.LANGUAGE, "Japanese (JPN)", "en", false));
                    theResp.setDomain(theDomain);
                    break;
                }
                EPPIdnTableInfoDomain theDomain = new EPPIdnTableInfoDomain(theCommand.getDomain(), true, false);
                theResp.setDomain(theDomain);
                break;
            }
            case TABLE_FORM: {
                cat.debug((Object)"doIdnTableInfo: Command with table form.");
                if (theCommand.getTable().equalsIgnoreCase("CHI")) {
                    EPPIdnTableInfoTable theTable = new EPPIdnTableInfoTable("CHI", EPPIdnTableInfoTable.Type.LANGUAGE, "Chinese (CHI)", new GregorianCalendar(2014, 11, 24, 9, 30).getTime());
                    theTable.setVersion("1.0");
                    theTable.setEffectiveDate(new GregorianCalendar(2014, 11, 24).getTime());
                    theTable.setVariantGen(new Boolean(true));
                    theTable.setUrl("https://www.iana.org/domains/idn-tables/tables/tld_chi_1.0.txt");
                    theResp.setTable(theTable);
                    break;
                }
                if (theCommand.getTable().equalsIgnoreCase("THAI")) {
                    EPPIdnTableInfoTable theTable = new EPPIdnTableInfoTable("THAI", EPPIdnTableInfoTable.Type.SCRIPT, "Thai", new GregorianCalendar(2014, 8, 16, 9, 20).getTime());
                    theTable.setVersion("1.0");
                    theTable.setEffectiveDate(new GregorianCalendar(2014, 11, 24).getTime());
                    theTable.setVariantGen(new Boolean(false));
                    theTable.setUrl("https://www.iana.org/domains/idn-tables/tables/tld_thai_1.0.txt");
                    theResp.setTable(theTable);
                    break;
                }
                EPPResponse theErrorResponse = new EPPResponse(theTransId);
                theErrorResponse.setResult(2303);
                theErrorResponse.getResult().addExtValueReason("IDN Table \"" + theCommand.getTable() + "\" does not exist");
                return new EPPEventResponse(theErrorResponse);
            }
            case LIST_FORM: {
                cat.debug((Object)"doIdnTableInfo: Command with list form.");
                theResp.addListItem(new EPPIdnTableInfoListItem("CHI", new GregorianCalendar(2015, 2, 4, 9, 30).getTime()));
                theResp.addListItem(new EPPIdnTableInfoListItem("JPN", new GregorianCalendar(2015, 1, 1, 9, 40).getTime()));
                theResp.addListItem(new EPPIdnTableInfoListItem("THAI", new GregorianCalendar(2014, 8, 16, 9, 20).getTime()));
                break;
            }
            case UNDEFINED_FORM: {
                cat.error((Object)"doIdnTableInfo: Command with undefined form.");
                EPPResponse theErrorResponse = new EPPResponse(theTransId);
                theErrorResponse.setResult(2306);
                theErrorResponse.getResult().addExtValueReason("IDN Table Info using undefined form");
                return new EPPEventResponse(theErrorResponse);
            }
        }
        cat.debug((Object)"doIdnTableInfo: exit");
        return new EPPEventResponse(theResp);
    }
}

