/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.secdnsext.v11;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtInfData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtKeyData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSecDNSDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPSecDNSDomainTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPDomain domain = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPSecDNSDomainTst(String name) {
        super(name);
    }

    public void testDomainInfo() {
        this.printStart("EPPSecDNSDomainTst testDomainInfo");
        try {
            EPPSecDNSExtInfData infData;
            System.out.println("\ntestDomainInfo: Domain info of key-data-interface.com");
            this.domain.addDomainName("key-data-interface.com");
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("testDomainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPSecDNSExtInfData.class)) {
                infData = (EPPSecDNSExtInfData)response.getExtension(EPPSecDNSExtInfData.class);
                Assert.assertEquals((int)2, (int)infData.getKeyData().size());
                for (EPPCodecComponent currKey : infData.getKeyData()) {
                    System.out.println("testDomainInfo: keyData = " + currKey);
                }
            } else {
                Assert.fail((String)"EPPSecDNSExtInfData extension not included for domain info of key-data-interface.com");
            }
            System.out.println("\ntestDomainInfo: Domain info of ds-data-interface-with-key.com");
            this.domain.addDomainName("ds-data-interface-with-key.com");
            response = this.domain.sendInfo();
            System.out.println("testDomainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPSecDNSExtInfData.class)) {
                infData = (EPPSecDNSExtInfData)response.getExtension(EPPSecDNSExtInfData.class);
                Assert.assertEquals((int)2, (int)infData.getDsData().size());
                for (EPPCodecComponent currKey : infData.getDsData()) {
                    System.out.println("testDomainInfo: dsData = " + currKey);
                }
            } else {
                Assert.fail((String)"EPPSecDNSExtInfData extension not included for domain info of ds-data-interface-with-key.com");
            }
            System.out.println("\ntestDomainInfo: Domain info of ds-data-interface-with-maxsiglife.com");
            this.domain.addDomainName("ds-data-interface-with-maxsiglife.com");
            response = this.domain.sendInfo();
            System.out.println("testDomainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPSecDNSExtInfData.class)) {
                infData = (EPPSecDNSExtInfData)response.getExtension(EPPSecDNSExtInfData.class);
                Assert.assertEquals((int)2, (int)infData.getDsData().size());
                for (EPPCodecComponent currKey : infData.getDsData()) {
                    System.out.println("testDomainInfo: dsData = " + currKey);
                }
                System.out.println("testDomainInfo: maxSigLife = " + infData.getMaxSigLife());
            } else {
                Assert.fail((String)"EPPSecDNSExtInfData extension not included for domain info of ds-data-interface-with-key.com");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("EPPSecDNSDomainTst testDomainInfo");
    }

    public void testCreateDsDataInterface() {
        this.printStart("EPPSecDNSDomainTst testCreateDsDataInterface");
        try {
            System.out.println("testCreateDsDataInterface(1): Create for a Secure Delegation example.com using the DS Data Interface with one DS");
            this.domain.addDomainName("testCreateDsDataInterface1.com");
            this.domain.setPeriodLength(2);
            this.domain.addHostName("ns1.example.com");
            this.domain.addHostName("ns1.example.com");
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setRegistrant("jd1234");
                this.domain.addContact("sh8013", "admin");
                this.domain.addContact("sh8013", "tech");
            }
            this.domain.setAuthString("2fooBAR");
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
            EPPSecDNSExtCreate secDNSExt = new EPPSecDNSExtCreate();
            secDNSExt.setMaxSigLife(604800);
            secDNSExt.appendDsData(dsData);
            this.domain.addExtension(secDNSExt);
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("testCreateDsDataInterface(1): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
            System.out.println("testCreateDsDataInterface(2): Create for a Secure Delegation example.com using the DS Data Interface with two DS");
            this.domain.addDomainName("testCreateDsDataInterface2.com");
            this.domain.setPeriodLength(2);
            this.domain.addHostName("ns1.example.com");
            this.domain.addHostName("ns1.example.com");
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setRegistrant("jd1234");
                this.domain.addContact("sh8013", "admin");
                this.domain.addContact("sh8013", "tech");
            }
            this.domain.setAuthString("2fooBAR");
            dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
            secDNSExt = new EPPSecDNSExtCreate();
            secDNSExt.setMaxSigLife(604800);
            secDNSExt.appendDsData(new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC"));
            secDNSExt.appendDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
            this.domain.addExtension(secDNSExt);
            response = this.domain.sendCreate();
            System.out.println("testCreateDsDataInterface(2): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
            System.out.println("testCreateDsDataInterface(3): Create for a Secure Delegation example.com using the DS Data Interface with OPTIONAL key data");
            this.domain.addDomainName("testCreateDsDataInterface3.com");
            this.domain.setPeriodLength(2);
            this.domain.addHostName("ns1.example.com");
            this.domain.addHostName("ns1.example.com");
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setRegistrant("jd1234");
                this.domain.addContact("sh8013", "admin");
                this.domain.addContact("sh8013", "tech");
            }
            this.domain.setAuthString("2fooBAR");
            EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
            keyData.setFlags(257);
            keyData.setProtocol(3);
            keyData.setAlg(5);
            keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
            try {
                dsData = keyData.toDsData("testCreateDsDataInterface.com", 1);
            }
            catch (EPPCodecException e) {
                this.handleException(e);
            }
            dsData.setKeyData(keyData);
            secDNSExt = new EPPSecDNSExtCreate();
            secDNSExt.setMaxSigLife(604800);
            secDNSExt.appendDsData(dsData);
            this.domain.addExtension(secDNSExt);
            response = this.domain.sendCreate();
            System.out.println("testCreateDsDataInterface(3): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public void testCreateKeyDataInterface() {
        this.printStart("EPPSecDNSDomainTst testCreateKeyDataInterface");
        try {
            System.out.println("testCreateKeyDataInterface(1): Create for a Secure Delegation example.com using the Key Data Interface with one key");
            this.domain.addDomainName("example.com");
            this.domain.setPeriodLength(2);
            this.domain.addHostName("ns1.example.com");
            this.domain.addHostName("ns1.example.com");
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setRegistrant("jd1234");
                this.domain.addContact("sh8013", "admin");
                this.domain.addContact("sh8013", "tech");
            }
            this.domain.setAuthString("2fooBAR");
            EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
            keyData.setFlags(257);
            keyData.setProtocol(3);
            keyData.setAlg(5);
            keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
            EPPSecDNSExtCreate secDNSExt = new EPPSecDNSExtCreate();
            secDNSExt.setMaxSigLife(604800);
            secDNSExt.appendKeyData(keyData);
            this.domain.addExtension(secDNSExt);
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("testCreateKeyDataInterface(1): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
            System.out.println("testCreateKeyDataInterface(2): Create for a Secure Delegation example.com using the Key Data Interface with two keys");
            this.domain.addDomainName("example.com");
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setRegistrant("jd1234");
                this.domain.addContact("sh8013", "admin");
                this.domain.addContact("sh8013", "tech");
            }
            this.domain.setAuthString("2fooBAR");
            EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData();
            keyData2.setFlags(257);
            keyData2.setProtocol(3);
            keyData2.setAlg(1);
            keyData2.setPubKey("AQPJ////4Q==");
            secDNSExt = new EPPSecDNSExtCreate();
            secDNSExt.appendKeyData(keyData);
            secDNSExt.appendKeyData(keyData2);
            this.domain.addExtension(secDNSExt);
            response = this.domain.sendCreate();
            System.out.println("testCreateKeyDataInterface(2): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)response.getResult().getCode(), (int)1000);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public void testCreateNegativeTests() {
        EPPDomainCreateResp response;
        this.printStart("EPPSecDNSDomainTst testCreateNegativeTests");
        System.out.println("testCreateNegativeTests(1): Passing DS data to server that only supports the Key Data Interface with domain key-data-interface.com");
        this.domain.addDomainName("key-data-interface.com");
        this.domain.setAuthString("2fooBAR");
        EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
        EPPSecDNSExtCreate secDNSExt = new EPPSecDNSExtCreate();
        secDNSExt.appendDsData(dsData);
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendCreate();
            Assert.fail((String)"Passing DS data to server that only supports the Key Data Interface was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testCreateNegativeTests(1): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)2306, (int)ex.getResponse().getResult().getCode());
        }
        System.out.println("testCreateNegativeTests(2): Passing Key data to server that only supports the DS Data Interface with domain ds-data-interface.com");
        this.domain.addDomainName("ds-data-interface.com");
        this.domain.setAuthString("2fooBAR");
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        secDNSExt = new EPPSecDNSExtCreate();
        secDNSExt.appendKeyData(keyData);
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendCreate();
            Assert.fail((String)"Passing Key data to server that only supports the DS Data Interface was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testCreateNegativeTests(2): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)ex.getResponse().getResult().getCode(), (int)2306);
        }
        System.out.println("testCreateNegativeTests(3): Setting maxSigLife for a server that does not support maxSigLife with domain maxsiglife-not-suported.com");
        this.domain.addDomainName("maxsiglife-not-supported.com");
        this.domain.setAuthString("2fooBAR");
        dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
        secDNSExt = new EPPSecDNSExtCreate();
        secDNSExt.setMaxSigLife(604800);
        secDNSExt.appendDsData(dsData);
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendCreate();
            Assert.fail((String)"Setting maxSigLife for a server that does not support maxSigLife was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testCreateNegativeTests(3): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)2102, (int)ex.getResponse().getResult().getCode());
        }
    }

    public void testUpdateDsDataInterface() {
        this.printStart("testUpdateDsDataInterface");
        try {
            System.out.println("testUpdateDsDataInterface(1): Adding and Removing DS Data using the DS Data Interface");
            EPPSecDNSExtUpdate secDNSExt = new EPPSecDNSExtUpdate();
            this.domain.addDomainName("testUpdateDsDataInterface1.com");
            this.domain.setTransId("ABC-12345");
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
            secDNSExt.appendAddDsData(dsData);
            secDNSExt.appendRemDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
            this.domain.addExtension(secDNSExt);
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("testUpdateDsDataInterface(1): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
            System.out.println("testUpdateDsDataInterface(2): Removing DS Data with <secDNS:dsData> using the DS Data Interface");
            secDNSExt = new EPPSecDNSExtUpdate();
            this.domain.addDomainName("testUpdateDsDataInterface2.com");
            this.domain.setTransId("ABC-12345");
            secDNSExt.appendRemDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
            this.domain.addExtension(secDNSExt);
            response = this.domain.sendUpdate();
            System.out.println("testUpdateDsDataInterface(2): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
            System.out.println("testUpdateDsDataInterface(3): Remove all DS and Key Data using <secDNS:rem> with <secDNS:all>");
            secDNSExt = new EPPSecDNSExtUpdate();
            this.domain.addDomainName("testUpdateDsDataInterface3.com");
            this.domain.setTransId("ABC-12345");
            secDNSExt.setUrgent(true);
            secDNSExt.setRemAllData(true);
            this.domain.addExtension(secDNSExt);
            response = this.domain.sendUpdate();
            System.out.println("testUpdateDsDataInterface(3): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
            System.out.println("testUpdateDsDataInterface(4): Replacing all DS Data using the DS Data Interface");
            secDNSExt = new EPPSecDNSExtUpdate();
            this.domain.addDomainName("testUpdateDsDataInterface4.com");
            this.domain.setTransId("ABC-12345");
            secDNSExt.setUrgent(true);
            secDNSExt.setRemAllData(true);
            secDNSExt.appendAddDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
            this.domain.addExtension(secDNSExt);
            response = this.domain.sendUpdate();
            System.out.println("testUpdateDsDataInterface(4): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
            System.out.println("testUpdateDsDataInterface(5): Update the maxSigLife");
            secDNSExt = new EPPSecDNSExtUpdate();
            this.domain.addDomainName("testUpdateDsDataInterface5.com");
            this.domain.setTransId("ABC-12345");
            secDNSExt.setMaxSigLife(605900);
            this.domain.addExtension(secDNSExt);
            response = this.domain.sendUpdate();
            System.out.println("testUpdateDsDataInterface(5): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("testUpdateDsDataInterface");
    }

    public void testUpdateKeyDataInterface() {
        this.printStart("testUpdateKeyDataInterface");
        try {
            System.out.println("testUpdateKeyDataInterface(1): Adding and Removing Key Data using the Key Data Interface");
            EPPSecDNSExtUpdate secDNSExt = new EPPSecDNSExtUpdate();
            this.domain.addDomainName("testUpdateKeyDataInterface1.com");
            this.domain.setTransId("ABC-12345");
            secDNSExt.appendAddKeyData(new EPPSecDNSExtKeyData(257, 3, 1, "AQPJ////4QQQ"));
            secDNSExt.appendRemKeyData(new EPPSecDNSExtKeyData(257, 3, 1, "AQPJ////4Q=="));
            this.domain.addExtension(secDNSExt);
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("testUpdateKeyDataInterface(1): Response = [" + response + "]\n\n");
            Assert.assertEquals((int)1000, (int)response.getResult().getCode());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("testUpdateKeyDataInterface");
    }

    public void testUpdateNegativeTests() {
        this.printStart("testUpdateNegativeTests");
        EPPResponse response = null;
        System.out.println("testUpdateNegativeTests(1): Pass an urgent flag of true to a server that does not support it with the domain urgent-not-supported.com");
        EPPSecDNSExtUpdate secDNSExt = new EPPSecDNSExtUpdate();
        this.domain.addDomainName("urgent-not-supported.com");
        secDNSExt.setUrgent(true);
        EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
        secDNSExt.appendAddDsData(dsData);
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendUpdate();
            Assert.fail((String)"Passing urgent flag to server that doesn't support it was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testUpdateNegativeTests(1): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)2102, (int)ex.getResponse().getResult().getCode());
        }
        System.out.println("testUpdateNegativeTests(2): Pass an urgent flag of true to a server that does support but unable to complete the command with high priority with the domain urgent-supported-cannot-be-urgent.com");
        secDNSExt = new EPPSecDNSExtUpdate();
        this.domain.addDomainName("urgent-supported-cannot-be-urgent.com");
        secDNSExt.setUrgent(true);
        dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
        secDNSExt.appendRemDsData(dsData);
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendUpdate();
            Assert.fail((String)"Passing urgent flag to server that supports it but can't complete it with high priority was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testUpdateNegativeTests(1): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)2306, (int)ex.getResponse().getResult().getCode());
        }
        System.out.println("testUpdateNegativeTests(3): Pass DS Data to a server that only supports the Key Data Interface with the domain key-data-interface.com");
        secDNSExt = new EPPSecDNSExtUpdate();
        this.domain.addDomainName("key-data-interface.com");
        dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
        secDNSExt.appendAddDsData(dsData);
        secDNSExt.appendRemDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendUpdate();
            Assert.fail((String)"Passing DS data to server that only supports the Key Data Interface was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testUpdateNegativeTests(3): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)2306, (int)ex.getResponse().getResult().getCode());
        }
        System.out.println("testUpdateNegativeTests(4): Pass Key Data to a server that only supports the DS Data Interface with the domain ds-data-interface.com");
        secDNSExt = new EPPSecDNSExtUpdate();
        this.domain.addDomainName("ds-data-interface.com");
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        secDNSExt.appendRemKeyData(keyData);
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendUpdate();
            Assert.fail((String)"Passing Key data to server that only supports the DS Data Interface was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testUpdateNegativeTests(4): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)2306, (int)ex.getResponse().getResult().getCode());
        }
        System.out.println("testUpdateNegativeTests(5): Pass the maxSigLife to a server that does not support it with the domain maxsiglife-not-supported.com");
        secDNSExt = new EPPSecDNSExtUpdate();
        this.domain.addDomainName("maxsiglife-not-supported.com");
        secDNSExt.setMaxSigLife(604800);
        this.domain.addExtension(secDNSExt);
        try {
            response = this.domain.sendUpdate();
            Assert.fail((String)"Passing maxSigLife to server that doesn't support it was unexpectedly successful");
        }
        catch (EPPCommandException ex) {
            System.out.println("testUpdateNegativeTests(5): Response = [" + ex.getResponse() + "]\n\n");
            Assert.assertEquals((int)2102, (int)ex.getResponse().getResult().getCode());
        }
        this.printEnd("testUpdateNegativeTests");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPSecDNSDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPSecDNSDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSecDNSDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread().getName() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(5) + ".tv");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

