/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.verificationcode.EPPSignedCode;
import com.verisign.epp.codec.verificationcode.RevokedVerificationCode;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class VerificationCodeRevocationList {
    private static Logger cat = Logger.getLogger((String)VerificationCodeRevocationList.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final int DEFAULT_VERSION = 1;
    private static final String HEADER_LINE = "verification-code,insertion-datetime";
    private int version = 1;
    private Date createdDate;
    private List<RevokedVerificationCode> revokedVerificationCodes = new ArrayList<RevokedVerificationCode>();

    public VerificationCodeRevocationList() {
    }

    public VerificationCodeRevocationList(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public VerificationCodeRevocationList(Date aCreatedDate, List<RevokedVerificationCode> aRevokedVerificationCodes) {
        this.createdDate = aCreatedDate;
        this.setRevokedVerificationCodes(this.revokedVerificationCodes);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int aVersion) {
        this.version = aVersion;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public List<RevokedVerificationCode> getRevokedVerificationCodes() {
        return this.revokedVerificationCodes;
    }

    public void setRevokedVerificationCodes(List<RevokedVerificationCode> aRevokedVerificationCodes) {
        this.revokedVerificationCodes = aRevokedVerificationCodes == null ? new ArrayList<RevokedVerificationCode>() : aRevokedVerificationCodes;
    }

    public void addRevokedVerificationCode(RevokedVerificationCode aRevokedVerificationCode) {
        this.revokedVerificationCodes.add(aRevokedVerificationCode);
    }

    public boolean isRevoked(EPPSignedCode aVerificationCode) {
        cat.debug((Object)"isRevoked(EPPSignedCode): enter");
        String verificationCode = aVerificationCode.getCode().getCode();
        for (RevokedVerificationCode currVerificationCode : this.revokedVerificationCodes) {
            if (!currVerificationCode.getCode().equals(verificationCode)) continue;
            cat.debug((Object)("isRevoked(EPPSignedCode): Verification Code = " + verificationCode + " is revoked"));
            cat.debug((Object)"isRevoked(EPPSignedCode): exit");
            return true;
        }
        cat.debug((Object)("isRevoked(EPPSignedCode): Verification Code = " + verificationCode + " is not revoked"));
        cat.debug((Object)"isRevoked(EPPSignedCode): exit");
        return false;
    }

    public String encode() throws EPPEncodeException {
        cat.debug((Object)"encode(): enter");
        if (this.createdDate == null) {
            throw new EPPEncodeException("encode(): create date required attribute is null.");
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(Integer.toString(this.version));
        strBuffer.append(',');
        strBuffer.append(EPPUtil.encodeTimeInstant(this.createdDate));
        strBuffer.append('\n');
        strBuffer.append(HEADER_LINE);
        strBuffer.append('\n');
        for (RevokedVerificationCode currRevokedVerificationCode : this.revokedVerificationCodes) {
            strBuffer.append(currRevokedVerificationCode.encode());
            strBuffer.append('\n');
        }
        cat.debug((Object)"encode(): exit");
        return strBuffer.toString();
    }

    public void decode(String aVerificationCodeRevocationListStr) throws EPPDecodeException {
        this.decode(new ByteArrayInputStream(aVerificationCodeRevocationListStr.getBytes()));
    }

    public void decode(InputStream aVerificationCodeRevocationListStream) throws EPPDecodeException {
        cat.debug((Object)"decode(InputStream): enter");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(aVerificationCodeRevocationListStream));
        try {
            String currLine = bufferedReader.readLine();
            if (currLine == null) {
                throw new EPPDecodeException("decode(InputStream): Empty Verification Code revocation list.");
            }
            int sepIndex = currLine.indexOf(44);
            if (sepIndex == -1) {
                throw new EPPDecodeException("decode(InputStream): , seperator first line of Verification Code revocation list");
            }
            String versionStr = currLine.substring(0, sepIndex);
            this.version = Integer.parseInt(versionStr);
            String createdDateStr = currLine.substring(sepIndex + 1);
            this.createdDate = EPPUtil.decodeTimeInstant(createdDateStr);
            currLine = bufferedReader.readLine();
            if (currLine == null) {
                throw new EPPDecodeException("decode(InputStream): Missing Verification Code revocation list header line.");
            }
            if (!currLine.equals(HEADER_LINE)) {
                throw new EPPDecodeException("decode(InputStream): Invalid or missing Verification Code revocation list header line: " + currLine);
            }
            while ((currLine = bufferedReader.readLine()) != null) {
                RevokedVerificationCode revokedVerificationCode = new RevokedVerificationCode();
                revokedVerificationCode.decode(currLine);
                this.addRevokedVerificationCode(revokedVerificationCode);
            }
        }
        catch (IOException e) {
            throw new EPPDecodeException("Error reading Verification Code: " + e);
        }
        cat.debug((Object)"decode(String): exit");
    }

    public Object clone() throws CloneNotSupportedException {
        VerificationCodeRevocationList clone = (VerificationCodeRevocationList)super.clone();
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof VerificationCodeRevocationList)) {
            cat.error((Object)"VerificationCodeRevocationList.equals(): aObject is not an VerificationCodeRevocationList");
            return false;
        }
        VerificationCodeRevocationList other = (VerificationCodeRevocationList)aObject;
        if (!EqualityUtil.equals(this.version, other.version)) {
            cat.error((Object)"VerificationCodeRevocationList.equals(): version not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, other.createdDate)) {
            cat.error((Object)"VerificationCodeRevocationList.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.revokedVerificationCodes, other.revokedVerificationCodes)) {
            cat.error((Object)"EPPMark.equals(): revokedVerificationCodes not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (EPPEncodeException e) {
            throw new RuntimeException(e);
        }
    }
}

