/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.verificationcode.EPPSignedCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPSchemaCachingParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPEncodedSignedCodeValue
extends EPPSignedCode {
    private static final long serialVersionUID = -2581814950269930902L;
    private static Logger cat = Logger.getLogger((String)EPPEncodedSignedCodeValue.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "code";
    public static final String ELM_NAME = "verificationCode:code";

    public EPPEncodedSignedCodeValue() {
    }

    public EPPEncodedSignedCodeValue(EPPSignedCode aSignedCode) throws EPPEncodeException, EPPDecodeException {
        super(aSignedCode.encode());
    }

    public EPPEncodedSignedCodeValue(EPPVerificationCode aCode) throws EPPEncodeException {
        super(aCode);
    }

    public EPPEncodedSignedCodeValue(String aCode, String aType) throws EPPEncodeException {
        super(aCode, aType);
    }

    public EPPEncodedSignedCodeValue(byte[] aEncodedSignedCodeArray) throws EPPDecodeException {
        cat.debug((Object)"EPPSignedCode(byte[]): enter");
        byte[] signedCodeXML = null;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(aEncodedSignedCodeArray);
            EPPSchemaCachingParser parser = new EPPSchemaCachingParser();
            Document doc = ((DocumentBuilder)parser).parse(is);
            Element elm = doc.getDocumentElement();
            String base64SignedCode = EPPUtil.getTextContent(elm);
            signedCodeXML = Base64.decodeBase64((String)base64SignedCode);
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding signed code array: " + ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException e) {}
            }
        }
        super.decode(signedCodeXML);
        cat.debug((Object)"EPPSignedCode.decode(byte[]): exit");
    }

    public EPPEncodedSignedCodeValue(InputStream aSCODE) throws EPPDecodeException {
        cat.debug((Object)"EPPEncodedSignedCodeValue.EPPEncodedSignedCodeValue(InputStream): enter");
        StringBuffer smdBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(aSCODE));
        boolean addToSCODE = false;
        try {
            String currLine;
            while ((currLine = bufferedReader.readLine()) != null) {
                if (currLine.equals("-----BEGIN ENCODED SCODE-----")) {
                    addToSCODE = true;
                    continue;
                }
                if (currLine.equals("-----END ENCODED SCODE-----")) {
                    addToSCODE = false;
                    continue;
                }
                if (!addToSCODE) continue;
                smdBuffer.append(currLine);
            }
        }
        catch (IOException e) {
            throw new EPPDecodeException("Error reading SCODE: " + e);
        }
        byte[] signedCodeXML = Base64.decodeBase64((String)smdBuffer.toString());
        super.decode(signedCodeXML);
        cat.debug((Object)"EPPEncodedSignedCodeValue.EPPEncodedSignedCodeValue(InputStream): exit");
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        cat.debug((Object)"EPPEncodedSignedCodeValue.decode(Element): enter");
        String base64SignedCode = EPPUtil.getTextContent(aElement);
        byte[] signedCodeXML = Base64.decodeBase64((String)base64SignedCode);
        super.decode(signedCodeXML);
        cat.debug((Object)"EPPEncodedSignedCodeValue.decode(Element): exit - normal");
    }

    @Override
    public byte[] encode() throws EPPEncodeException {
        cat.debug((Object)"EPPEncodedSignedCodeValue.encode(): enter");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element root = this.encode((Document)doc);
            doc.appendChild(root);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(root), new StreamResult(os));
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cat.error((Object)("Error encoding tradecode to byte[]: " + ex));
            throw new EPPEncodeException("Error encoding tradecode to byte[]");
        }
        cat.debug((Object)"EPPEncodedSignedCodeValue.encode(): exit");
        return os.toByteArray();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug((Object)"EPPEncodedSignedCodeValue.encode(Document): enter");
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPSignedCode.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", ELM_NAME);
        byte[] signedCodeXml = super.encode();
        String base64EncodedText = new String(Base64.encodeBase64((byte[])signedCodeXml, (boolean)true));
        Text currVal = aDocument.createTextNode(base64EncodedText);
        root.appendChild(currVal);
        cat.debug((Object)"EPPEncodedSignedCodeValue.encode(Document): exit - encoded");
        return root;
    }

    public String encodeValue() throws EPPEncodeException {
        byte[] signedCodeXml = super.encode();
        String base64EncodedText = new String(Base64.encodeBase64((byte[])signedCodeXml, (boolean)true));
        return base64EncodedText;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPEncodedSignedCodeValue)super.clone();
    }
}

