/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.signedMark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPIssuer
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPIssuer.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "issuerInfo";
    public static final String ELM_NAME = "signedMark:issuerInfo";
    private static final String ELM_ORG = "org";
    private static final String ELM_EMAIL = "email";
    private static final String ELM_URL = "url";
    private static final String ELM_VOICE = "voice";
    private static final String ATTR_ID = "issuerID";
    private static final String ATTR_EXT = "x";
    private String id;
    private String org;
    private String email;
    private String url;
    private String voice;
    private String voiceExt;

    public EPPIssuer() {
    }

    public EPPIssuer(String aId, String aOrg, String aEmail) {
        this.id = aId;
        this.org = aOrg;
        this.email = aEmail;
    }

    public EPPIssuer(String aId, String aOrg, String aEmail, String aUrl, String aVoice, String aVoiceExt) {
        this.id = aId;
        this.org = aOrg;
        this.email = aEmail;
        this.url = aUrl;
        this.voice = aVoice;
        this.voiceExt = aVoiceExt;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIssuer clone = (EPPIssuer)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPIssuer.encode(Document)");
        }
        if (this.id == null) {
            throw new EPPEncodeException("Issuer id is required.");
        }
        if (this.email == null) {
            throw new EPPEncodeException("Issuer email is required.");
        }
        if (this.org == null) {
            throw new EPPEncodeException("Issuer org is required.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:signedMark-1.0", ELM_NAME);
        root.setAttribute(ATTR_ID, this.id);
        EPPUtil.encodeString(aDocument, root, this.org, "urn:ietf:params:xml:ns:signedMark-1.0", "signedMark:org");
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:signedMark-1.0", "signedMark:email");
        EPPUtil.encodeString(aDocument, root, this.url, "urn:ietf:params:xml:ns:signedMark-1.0", "signedMark:url");
        if (this.voice != null) {
            Element currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:signedMark-1.0", "signedMark:voice");
            Text currVal = aDocument.createTextNode(this.voice);
            if (currVal != null) {
                currElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.id = aElement.getAttribute(ATTR_ID);
        this.org = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:signedMark-1.0", ELM_ORG);
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:signedMark-1.0", ELM_EMAIL);
        this.url = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:signedMark-1.0", ELM_URL);
        this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:signedMark-1.0", ELM_VOICE);
        if (this.voice != null) {
            Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:signedMark-1.0", ELM_VOICE);
            this.voiceExt = currElm.getAttribute(ATTR_EXT);
            if (this.voiceExt.isEmpty()) {
                this.voiceExt = null;
            }
        } else {
            this.voiceExt = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIssuer)) {
            cat.error((Object)"EPPIssuer.equals(): aObject is not an EPPIssuer");
            return false;
        }
        EPPIssuer other = (EPPIssuer)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error((Object)"EPPIssuer.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.org, other.org)) {
            cat.error((Object)"EPPIssuer.equals(): org not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error((Object)"EPPIssuer.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error((Object)"EPPIssuer.equals(): url not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error((Object)"EPPIssuer.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error((Object)"EPPIssuer.equals(): voiceExt not equal");
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String aOrg) {
        this.org = aOrg;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

