/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryZone
implements EPPCodecComponent {
    private static final long serialVersionUID = 3697102804288584732L;
    private static Logger cat = Logger.getLogger((String)EPPRegistryZone.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    static final String ELM_NAME = "registry:zone";
    static final String ELM_ZONE_NAME = "registry:name";
    static final String ELM_CREATE_DATE = "registry:crDate";
    static final String ELM_UPDATE_DATE = "registry:upDate";
    private String name;
    private Date createDate;
    private Date updateDate;

    public EPPRegistryZone() {
    }

    public EPPRegistryZone(String name, Date createDate) {
        this();
        this.name = name;
        this.createDate = createDate;
    }

    public EPPRegistryZone(String name, Date createDate, Date updateDate) {
        this(name, createDate);
        this.updateDate = updateDate;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)(this.getClass().getName() + ".encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode(): " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.verisign.com/epp/registry-1.0", ELM_ZONE_NAME);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createDate, "http://www.verisign.com/epp/registry-1.0", ELM_CREATE_DATE);
        if (this.updateDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.updateDate, "http://www.verisign.com/epp/registry-1.0", ELM_UPDATE_DATE);
        }
        return root;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.createDate == null) {
            throw new EPPCodecException("createDate required attribute is not set");
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_ZONE_NAME);
        this.createDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CREATE_DATE);
        this.updateDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_UPDATE_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryZone)) {
            return false;
        }
        EPPRegistryZone theComp = (EPPRegistryZone)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.createDate != null ? this.createDate.equals(theComp.createDate) : theComp.createDate == null)) {
            return false;
        }
        return this.updateDate != null ? this.updateDate.equals(theComp.updateDate) : theComp.updateDate == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryZone clone = (EPPRegistryZone)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}

