/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.premiumdomain;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheck;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheckResp;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheckResult;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainReAssignCmd;
import com.verisign.epp.util.TestThread;
import java.math.BigDecimal;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPPremiumDomainTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPPremiumDomainTst(String name) {
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testSinglePremiumDomainCheck() {
        EPPCodecTst.printStart("testSinglePremiumDomainCheck");
        EPPCodecTst.setNumIterations(numIterations);
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd("ABC-12345", "example-flag-true.tv");
        theCommand.addExtension(new EPPPremiumDomainCheck(true));
        EPPCodecTst.testEncodeDecode(theCommand);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCheckResp theResponse = new EPPDomainCheckResp(respTransId, new EPPDomainCheckResult(theCommand.getNames().get(0).toString(), true));
        theResponse.setResult(1000);
        EPPPremiumDomainCheckResult eppPremiumDomainCheckResult = null;
        eppPremiumDomainCheckResult = new EPPPremiumDomainCheckResult(theCommand.getNames().get(0).toString(), true);
        eppPremiumDomainCheckResult.setPrice(new BigDecimal("125.00"));
        eppPremiumDomainCheckResult.setRenewalPrice(new BigDecimal("75.00"));
        eppPremiumDomainCheckResult.setPriceUnit("USD");
        EPPPremiumDomainCheckResp respExt = new EPPPremiumDomainCheckResp(eppPremiumDomainCheckResult);
        theResponse.addExtension(respExt);
        EPPCodecTst.testEncodeDecode(theResponse);
        theCommand = new EPPDomainCheckCmd("ABC-12345", "example-flag-false.tv");
        theCommand.addExtension(new EPPPremiumDomainCheck(false));
        EPPCodecTst.testEncodeDecode(theCommand);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPDomainCheckResp(respTransId, new EPPDomainCheckResult(theCommand.getNames().get(0).toString(), true));
        theResponse.setResult(1000);
        EPPCodecTst.testEncodeDecode(theResponse);
        EPPCodecTst.printEnd("testSinglePremiumDomainCheck");
    }

    public void testMultiplePremiumDomainCheck() {
        int i;
        int i2;
        EPPCodecTst.printStart("testMultiplePremiumDomainCheck");
        EPPPremiumDomainCheckResp respExt = null;
        EPPPremiumDomainCheckResult eppPremiumDomainCheckResult = null;
        Vector<String> domains = null;
        Vector<EPPDomainCheckResult> domainResults = null;
        Vector<EPPPremiumDomainCheckResult> premiumResults = null;
        boolean available = true;
        EPPCodecTst.setNumIterations(numIterations);
        domains = new Vector<String>();
        for (i2 = 1; i2 <= 3; ++i2) {
            domains.addElement("example-flag-true-" + i2 + ".tv");
        }
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd("ABC-12345", domains);
        theCommand.addExtension(new EPPPremiumDomainCheck(true));
        EPPCodecTst.testEncodeDecode(theCommand);
        domainResults = new Vector<EPPDomainCheckResult>();
        for (i2 = 0; i2 < domains.size(); ++i2) {
            domainResults.addElement(new EPPDomainCheckResult(theCommand.getNames().get(i2).toString(), available));
            available = !available;
        }
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCheckResp theResponse = new EPPDomainCheckResp(respTransId, domainResults);
        theResponse.setResult(1000);
        premiumResults = new Vector<EPPPremiumDomainCheckResult>();
        for (i = 0; i < theResponse.getCheckResults().size(); ++i) {
            EPPDomainCheckResult currResult = (EPPDomainCheckResult)theResponse.getCheckResults().elementAt(i);
            eppPremiumDomainCheckResult = new EPPPremiumDomainCheckResult(currResult.getName(), true);
            if (currResult.isAvailable()) {
                eppPremiumDomainCheckResult.setPrice(new BigDecimal("125.00"));
                eppPremiumDomainCheckResult.setRenewalPrice(new BigDecimal("75.00"));
                eppPremiumDomainCheckResult.setPriceUnit("USD");
            }
            premiumResults.addElement(eppPremiumDomainCheckResult);
        }
        respExt = new EPPPremiumDomainCheckResp(premiumResults);
        theResponse.addExtension(respExt);
        EPPCodecTst.testEncodeDecode(theResponse);
        domains = new Vector();
        for (i = 1; i <= 3; ++i) {
            domains.addElement("example-flag-false-" + i + ".tv");
        }
        theCommand = new EPPDomainCheckCmd("ABC-12345", domains);
        theCommand.addExtension(new EPPPremiumDomainCheck(false));
        EPPCodecTst.testEncodeDecode(theCommand);
        domainResults = new Vector();
        for (i = 0; i < domains.size(); ++i) {
            domainResults.addElement(new EPPDomainCheckResult(theCommand.getNames().get(i).toString(), available));
            available = !available;
        }
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPDomainCheckResp(respTransId, domainResults);
        theResponse.setResult(1000);
        EPPCodecTst.testEncodeDecode(theResponse);
        EPPCodecTst.printEnd("testMultiplePremiumDomainCheck");
    }

    public void testPremiumDomainReAssign() {
        EPPCodecTst.printStart("testPremiumDomainReAssign");
        EPPCodecTst.setNumIterations(numIterations);
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("premium.tv");
        theCommand.setTransId("ABC-12345-XYZ");
        theCommand.addExtension(new EPPPremiumDomainReAssignCmd("testregistrar"));
        EPPCodecTst.testEncodeDecode(theCommand);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPCodecTst.testEncodeDecode(theResponse);
        EPPCodecTst.printEnd("testPremiumDomainReAssign");
    }

    public static Test suite() {
        System.setProperty("validate", "true");
        System.setProperty("fullschemachecking", "false");
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPPremiumDomainTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.premiumdomain.EPPPremiumDomainExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPPremiumDomainExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPPremiumDomainTst Thread " + i, EPPPremiumDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPPremiumDomainTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

