/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckResp;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoResp;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPIdnTableMapFactory
extends EPPMapFactory {
    public static final String NS = "urn:ietf:params:xml:ns:idnTable-1.0";
    public static final String NS_PREFIX = "idnTable";
    public static final String NS_SCHEMA = "urn:ietf:params:xml:ns:idnTable-1.0 idnTable-1.0.xsd";
    private EPPService service = new EPPService("idnTable", "urn:ietf:params:xml:ns:idnTable-1.0", "urn:ietf:params:xml:ns:idnTable-1.0 idnTable-1.0.xsd");

    public EPPIdnTableMapFactory() {
        this.service.setServiceType(0);
    }

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("idnTable:check"))) {
            return new EPPIdnTableCheckCmd();
        }
        if (name.equals(EPPUtil.getLocalName("idnTable:info"))) {
            return new EPPIdnTableInfoCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("idnTable:chkData"))) {
            return new EPPIdnTableCheckResp();
        }
        if (name.equals(EPPUtil.getLocalName("idnTable:infData"))) {
            return new EPPIdnTableInfoResp();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        theSchemas.add("idnTable-1.0.xsd");
        return theSchemas;
    }
}

