/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPIdnTableCheckDomain
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPIdnTableCheckDomain.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "domain";
    public static final String ELM_NAME = "idnTable:domain";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ELM_TABLE = "table";
    private static final String ELM_REASON = "reason";
    private static final String ATTR_VALID = "valid";
    private static final String ATTR_IDNMAP = "idnmap";
    private static final String ATTR_LANG = "lang";
    private String name;
    private boolean valid;
    private boolean idnmap = true;
    private List<String> tables = new ArrayList<String>();
    private String reason;
    private String reasonLang;

    public EPPIdnTableCheckDomain() {
    }

    public EPPIdnTableCheckDomain(String aName, boolean aValid) {
        this.setName(aName);
        this.setValid(aValid);
    }

    public EPPIdnTableCheckDomain(String aName, boolean aValid, boolean aIdnmap) {
        this.setName(aName);
        this.setValid(aValid);
        this.setIdnmap(aIdnmap);
    }

    public EPPIdnTableCheckDomain(String aDomain, String aReason) {
        this.setName(aDomain);
        this.setValid(false);
        this.setReason(aReason);
    }

    public EPPIdnTableCheckDomain(String aDomain, List<String> aTables) {
        this.setName(aDomain);
        this.setValid(true);
        this.setTables(aTables);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aDomain) {
        this.name = aDomain;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean aValid) {
        this.valid = aValid;
    }

    public boolean isIdnmap() {
        return this.idnmap;
    }

    public void setIdnmap(boolean aIdnmap) {
        this.idnmap = aIdnmap;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public boolean hasReasonLang() {
        return this.reasonLang != null;
    }

    public String getReasonLang() {
        return this.reasonLang;
    }

    public void setReasonLang(String aReasonLang) {
        this.reasonLang = aReasonLang;
    }

    public boolean hasTables() {
        return this.tables != null && !this.tables.isEmpty();
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(List<String> aTables) {
        this.tables = aTables;
    }

    public void setTable(String aTable) {
        this.tables = new ArrayList<String>();
        this.tables.add(aTable);
    }

    public void addTable(String aTable) {
        this.tables.add(aTable);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("Undefined name in EPPIdnTableCheckDomain");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        Element theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:name");
        theElm.appendChild(aDocument.createTextNode(this.name));
        EPPUtil.encodeBooleanAttr(theElm, ATTR_VALID, this.valid);
        EPPUtil.encodeBooleanAttr(theElm, ATTR_IDNMAP, this.idnmap);
        root.appendChild(theElm);
        if (this.hasReason()) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:reason");
            if (this.hasReasonLang()) {
                reasonElm.setAttribute(ATTR_LANG, this.reasonLang);
            }
            reasonElm.appendChild(aDocument.createTextNode(this.reason));
            root.appendChild(reasonElm);
        }
        EPPUtil.encodeList(aDocument, root, this.tables, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:table");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theReasonElm;
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_DOMAIN_NAME);
        if (theNameElm != null) {
            Node textNode = theNameElm.getFirstChild();
            this.name = textNode != null ? textNode.getNodeValue() : null;
            this.valid = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_VALID);
            try {
                this.idnmap = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_IDNMAP);
            }
            catch (EPPDecodeException ex) {
                cat.debug((Object)"EPPIdnTableCheckDomain.decode(): idnmap attribute undefined, setting to default of true.");
                this.idnmap = true;
            }
        }
        if ((theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_REASON)) != null) {
            Node textNode = theReasonElm.getFirstChild();
            if (textNode != null) {
                this.reason = textNode.getNodeValue();
                String theReasonLang = theReasonElm.getAttribute(ATTR_LANG);
                this.reasonLang = theReasonLang != null && !theReasonLang.isEmpty() ? theReasonLang : null;
            } else {
                this.reason = null;
                this.reasonLang = null;
            }
        } else {
            this.reason = null;
            this.reasonLang = null;
        }
        this.tables = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TABLE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableCheckDomain clone = (EPPIdnTableCheckDomain)super.clone();
        clone.tables = (List)((ArrayList)this.tables).clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableCheckDomain)) {
            return false;
        }
        EPPIdnTableCheckDomain other = (EPPIdnTableCheckDomain)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPIdnTableCheckDomain.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.valid, other.valid)) {
            cat.error((Object)"EPPIdnTableCheckDomain.equals(): valid not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.idnmap, other.idnmap)) {
            cat.error((Object)"EPPIdnTableCheckDomain.equals(): idnmap not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error((Object)"EPPIdnTableCheckDomain.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reasonLang, other.reasonLang)) {
            cat.error((Object)"EPPIdnTableCheckDomain.equals(): reasonLang not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.tables, other.tables)) {
            cat.error((Object)"EPPIdnTableCheckDomain.equals(): tables not equal");
            return false;
        }
        return true;
    }
}

