/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.coaext;

import com.verisign.epp.codec.coaext.EPPCoaExtAttr;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPCoaExtCreate
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = Logger.getLogger((String)EPPCoaExtCreate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "coa:create";
    private List attrs = null;

    public EPPCoaExtCreate() {
    }

    public EPPCoaExtCreate(List aAttrs) {
        this.attrs = aAttrs;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.attrs = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:coa-1.0", "coa:attr", EPPCoaExtAttr.class);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPCoaExtCreate.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPCoaExtCreate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPCoaExtCreate invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:coa-1.0", ELM_NAME);
        root.setAttribute("xmlns:coa", "urn:ietf:params:xml:ns:coa-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:coa-1.0 coa-1.0.xsd");
        EPPUtil.encodeCompList(aDocument, root, this.attrs);
        return root;
    }

    private void validateState() throws EPPCodecException {
        if (this.attrs == null || this.attrs.size() == 0) {
            throw new EPPCodecException("EPPCoaExtCreate contains no attr elements.");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCoaExtCreate theClone = new EPPCoaExtCreate();
        if (this.attrs != null) {
            for (Object attrObject : this.attrs) {
                if (attrObject == null) continue;
                EPPCoaExtAttr attr = (EPPCoaExtAttr)attrObject;
                theClone.appendAttr((EPPCoaExtAttr)attr.clone());
            }
        }
        return theClone;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof EPPCoaExtCreate)) {
            return false;
        }
        EPPCoaExtCreate theComp = (EPPCoaExtCreate)aObj;
        return EPPUtil.equalLists(this.attrs, theComp.attrs);
    }

    public void appendAttr(EPPCoaExtAttr aAttr) {
        if (aAttr == null) {
            return;
        }
        if (this.attrs == null) {
            this.attrs = new ArrayList();
        }
        this.attrs.add(aAttr);
    }

    public List getAttrs() {
        return this.attrs;
    }

    public void setAttrs(List aAttrs) {
        this.attrs = aAttrs;
    }
}

