/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.defReg.EPPDefRegCheckResp;
import com.verisign.epp.codec.defReg.EPPDefRegCheckResult;
import com.verisign.epp.codec.defReg.EPPDefRegCreateResp;
import com.verisign.epp.codec.defReg.EPPDefRegInfoResp;
import com.verisign.epp.codec.defReg.EPPDefRegRenewResp;
import com.verisign.epp.codec.defReg.EPPDefRegStatus;
import com.verisign.epp.codec.defReg.EPPDefRegTransferResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.idnext.EPPIdnLangTag;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDefReg;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPDefRegTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPDefRegTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPDefReg defReg = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPDefRegTst(String name) {
        super(name);
    }

    public void testDefReg() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.defRegCheck();
            this.defRegInfo();
            this.defRegCreate();
            this.defRegCreateIDN();
            this.defRegDelete();
            this.defRegRenew();
            this.defRegUpdate();
            this.defRegTransferQuery();
            this.defRegTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void defRegCheck() {
        this.printStart("defRegCheck");
        try {
            int i;
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("defRegCheck: Check defReg names (smith, doe, john.smith)");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.addDefRegName("premium", "smith");
            this.defReg.addDefRegName("premium", "doe");
            this.defReg.addDefRegName("standard", "john.smith");
            EPPDefRegCheckResp response = this.defReg.sendCheck();
            System.out.println("Response Type = " + response.getType());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getClientTransId());
            System.out.println("\ndefRegCheck: Response = [" + response + "]");
            for (i = 0; i < response.getCheckResults().size(); ++i) {
                EPPDefRegCheckResult currResult = (EPPDefRegCheckResult)response.getCheckResults().elementAt(i);
                if (currResult.isAvailable()) {
                    System.out.println("defRegCheck: DefReg " + currResult.getName() + " is known");
                    continue;
                }
                System.out.println("defRegCheck: DefReg " + currResult.getName() + " is not known");
            }
            for (i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.printEnd("defRegCheck");
    }

    public void defRegInfo() {
        this.printStart("defRegInfo");
        try {
            int i;
            System.out.println("\ndefRegInfo: DefReg info for EXAMPLE1-REP");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.setRoid("EXAMPLE1-REP");
            EPPDefRegInfoResp response = this.defReg.sendInfo();
            System.out.println("defRegInfo: Response = [" + response + "]\n\n");
            System.out.println("defRegInfo: name            = " + response.getName());
            System.out.println("defRegInfo: client id       = " + response.getClientId());
            System.out.println("defRegInfo: created by      = " + response.getCreatedBy());
            System.out.println("defRegInfo: create date     = " + response.getCreatedDate());
            System.out.println("defRegInfo: expiration date = " + response.getExpirationDate());
            System.out.println("defRegInfo: Registrant      = " + response.getRegistrant());
            if (response.getAuthInfo() != null) {
                System.out.println("Authorization        : " + response.getAuthInfo().getPassword());
                System.out.println("Authorization (Roid) : " + response.getAuthInfo().getRoid());
            }
            if (response.getStatuses() != null) {
                for (i = 0; i < response.getStatuses().size(); ++i) {
                    EPPDefRegStatus myStatus = (EPPDefRegStatus)response.getStatuses().elementAt(i);
                    System.out.println("Lang     : " + myStatus.getLang());
                    System.out.println("Status   : " + myStatus.getStatus());
                }
            }
            for (i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegInfo");
    }

    public void defRegCreate() {
        EPPDefRegCreateResp response;
        this.printStart("defRegCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("defRegCreate: Create doe premium defreg");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.addDefRegName("premium", "doe");
            this.defReg.setRegistrant("sh8013");
            this.defReg.setTm("Example");
            this.defReg.setTmCountry("US");
            this.defReg.setTmDate(new GregorianCalendar(1990, 4, 3).getTime());
            this.defReg.setAdminContact("sh8013");
            this.defReg.setAuthString("2fooBAR");
            response = this.defReg.sendCreate();
            System.out.println("defRegCreate: Response = [" + response + "]\n\n");
            System.out.println("defRegCreate: name = " + response.getName());
            System.out.println("defRegCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("defRegCreate: Create john.smith with all optional attributes");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.addDefRegName("standard", "john.smith");
            this.defReg.setRegistrant("sh8013");
            this.defReg.setTm("Example");
            this.defReg.setTmCountry("US");
            this.defReg.setTmDate(new GregorianCalendar(1990, 4, 3).getTime());
            this.defReg.setAdminContact("sh8013");
            this.defReg.setAuthString("2fooBAR");
            this.defReg.setPeriodLength(10);
            response = this.defReg.sendCreate();
            System.out.println("defRegCreate: Response = [" + response + "]\n\n");
            System.out.println("defRegCreate: name = " + response.getName());
            System.out.println("defRegCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegCreate");
    }

    public void defRegCreateIDN() {
        EPPDefRegCreateResp response;
        this.printStart("defRegCreateIDN");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("defRegCreate: Create xn--gya premium defreg");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.addDefRegName("premium", "xn--gya");
            this.defReg.setRegistrant("sh8013");
            this.defReg.setTm("Example");
            this.defReg.setTmCountry("US");
            this.defReg.setTmDate(new GregorianCalendar(1990, 4, 3).getTime());
            this.defReg.setAdminContact("sh8013");
            this.defReg.setAuthString("2fooBAR");
            this.defReg.addExtension(new EPPIdnLangTag("GRE"));
            response = this.defReg.sendCreate();
            System.out.println("defRegCreate: Response = [" + response + "]\n\n");
            System.out.println("defRegCreate: name = " + response.getName());
            System.out.println("defRegCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("defRegCreate: Create xn--2xa.xn--2xa with all optional attributes");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.addDefRegName("standard", "xn--2xa.xn--2xa");
            this.defReg.setRegistrant("sh8013");
            this.defReg.setTm("Example");
            this.defReg.setTmCountry("US");
            this.defReg.setTmDate(new GregorianCalendar(1990, 4, 3).getTime());
            this.defReg.setAdminContact("sh8013");
            this.defReg.setAuthString("2fooBAR");
            this.defReg.setPeriodLength(10);
            this.defReg.addExtension(new EPPIdnLangTag("GRE"));
            response = this.defReg.sendCreate();
            System.out.println("defRegCreate: Response = [" + response + "]\n\n");
            System.out.println("defRegCreate: name = " + response.getName());
            System.out.println("defRegCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegCreateIDN");
    }

    public void defRegDelete() {
        this.printStart("defRegDelete");
        try {
            System.out.println("\ndefRegDelete: DefReg delete for EXAMPLE1-REP");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.setRoid("EXAMPLE1-REP");
            EPPResponse response = this.defReg.sendDelete();
            System.out.println("defRegDelete: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegDelete");
    }

    public void defRegRenew() {
        this.printStart("defRegRenew");
        try {
            System.out.println("\ndefRegRenew: DefReg delete for EXAMPLE1-REP");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.setRoid("EXAMPLE1-REP");
            this.defReg.setExpirationDate(new GregorianCalendar(2004, 2, 3).getTime());
            this.defReg.setPeriodLength(10);
            this.defReg.setPeriodUnit("y");
            EPPDefRegRenewResp response = this.defReg.sendRenew();
            System.out.println("defRegRenew: Response = [" + response + "]\n\n");
            System.out.println("defRegRenew: roid = " + response.getRoid());
            System.out.println("defRegRenew: expiration date = " + response.getExpirationDate());
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegRenew");
    }

    public void defRegUpdate() {
        this.printStart("defRegUpdate");
        try {
            System.out.println("\ndefRegUpdate: DefReg update for EXAMPLE1-REP");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.setRoid("EXAMPLE1-REP");
            this.defReg.setRegistrant("sh8013");
            this.defReg.setAdminContact("sh8013");
            this.defReg.addStatus(new EPPDefRegStatus("clientDeleteProhibited"));
            this.defReg.removeStatus(new EPPDefRegStatus("clientUpdateProhibited"));
            EPPResponse response = this.defReg.sendUpdate();
            System.out.println("defRegUpdate: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegUpdate");
    }

    public void defRegTransferQuery() {
        this.printStart("defRegTransferQuery");
        try {
            System.out.println("\ndefRegTransferQuery: DefReg transfer query for EXAMPLE1-REP");
            this.defReg.setTransferOpCode("query");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.setRoid("EXAMPLE1-REP");
            EPPDefRegTransferResp response = this.defReg.sendTransfer();
            System.out.println("defRegTransferQuery: Response = [" + response + "]\n\n");
            System.out.println("defRegTransferQuery: roid = " + response.getRoid());
            System.out.println("defRegTransferQuery: request client = " + response.getRequestClient());
            System.out.println("defRegTransferQuery: action client = " + response.getActionClient());
            System.out.println("defRegTransferQuery: transfer status = " + response.getTransferStatus());
            System.out.println("defRegTransferQuery: request date = " + response.getRequestDate());
            System.out.println("defRegTransferQuery: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("defRegTransferQuery: expiration date = " + response.getExpirationDate());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegTransferQuery");
    }

    public void defRegTransfer() {
        EPPDefRegTransferResp response;
        this.printStart("defRegTransfer");
        try {
            System.out.println("\ndefRegTransfer: DefReg transfer request for EXAMPLE1-REP");
            this.defReg.setTransferOpCode("request");
            this.defReg.setTransId("ABC-12345-XYZ");
            this.defReg.setAuthString("ClientX");
            this.defReg.setRoid("EXAMPLE1-REP");
            this.defReg.setPeriodLength(10);
            this.defReg.setPeriodUnit("y");
            response = this.defReg.sendTransfer();
            System.out.println("defRegTransfer: Response = [" + response + "]\n\n");
            System.out.println("defRegTransfer: roid = " + response.getRoid());
            System.out.println("defRegTransfer: request client = " + response.getRequestClient());
            System.out.println("defRegTransfer: action client = " + response.getActionClient());
            System.out.println("defRegTransfer: transfer status = " + response.getTransferStatus());
            System.out.println("defRegTransfer: request date = " + response.getRequestDate());
            System.out.println("defRegTransfer: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("defRegTransfer: expiration date = " + response.getExpirationDate());
            }
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ndefRegTransfer: DefReg transfer cancel for EXAMPLE1-REP");
            this.defReg.setTransferOpCode("cancel");
            this.defReg.setRoid("EXAMPLE1-REP");
            response = this.defReg.sendTransfer();
            System.out.println("defRegTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ndefRegTransfer: DefReg transfer reject for EXAMPLE1-REP");
            this.defReg.setTransferOpCode("reject");
            this.defReg.setRoid("EXAMPLE1-REP");
            response = this.defReg.sendTransfer();
            System.out.println("defRegTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ndefRegTransfer: DefReg transfer approve for EXAMPLE1-REP");
            this.defReg.setTransferOpCode("approve");
            this.defReg.setRoid("EXAMPLE1-REP");
            response = this.defReg.sendTransfer();
            System.out.println("defRegTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("defRegTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            this.session = new EPPSession();
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.defReg = new EPPDefReg(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPDefRegTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPDefRegTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPDefRegTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDefRegName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + "@verisign.com");
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

