/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPVerificationCodeProfile
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPVerificationCodeProfile.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "profile";
    public static final String ELM_NAME = "verificationCode:profile";
    private static final String ATTR_PROFILE_NAME = "name";
    private static final String ELM_STATUS = "status";
    private static final String ELM_MISSING = "missing";
    private static final String ELM_SET = "set";
    Status status = Status.NON_COMPLIANT;
    String profileName;
    private List<EPPVerificationCode> missingCodes = new ArrayList<EPPVerificationCode>();
    private List<EPPVerificationCode> setCodes = new ArrayList<EPPVerificationCode>();

    public EPPVerificationCodeProfile() {
    }

    public EPPVerificationCodeProfile(String aProfileName, Status aStatus) {
        this.profileName = aProfileName;
        this.status = aStatus;
    }

    public EPPVerificationCodeProfile(String aProfileName, Status aStatus, List<EPPVerificationCode> aMissingCodes, List<EPPVerificationCode> aSetCodes) {
        this.status = aStatus;
        this.profileName = aProfileName;
        this.setMissingCodes(aMissingCodes);
        this.setSetCodes(aSetCodes);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPVerificationCodeProfile clone = (EPPVerificationCodeProfile)super.clone();
        clone.status = this.status;
        clone.profileName = this.profileName;
        clone.missingCodes = new ArrayList<EPPVerificationCode>(this.missingCodes.size());
        for (EPPVerificationCode item : this.missingCodes) {
            clone.missingCodes.add((EPPVerificationCode)item.clone());
        }
        clone.setCodes = new ArrayList<EPPVerificationCode>(this.setCodes.size());
        for (EPPVerificationCode item : this.setCodes) {
            clone.setCodes.add((EPPVerificationCode)item.clone());
        }
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPVerificationCodeInfData.encode(Document)");
        }
        if (this.profileName == null) {
            throw new EPPEncodeException("Required profileName is null on in EPPVerificationCodeInfData.encode(Document)");
        }
        if (this.status == null) {
            throw new EPPEncodeException("Required status is null on in EPPVerificationCodeInfData.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", ELM_NAME);
        root.setAttribute(ATTR_PROFILE_NAME, this.profileName);
        EPPUtil.encodeString(aDocument, root, this.status.toString(), "urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:status");
        if (this.hasMissingCodes()) {
            Element missing = aDocument.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:missing");
            EPPUtil.encodeCompList(aDocument, missing, this.missingCodes);
            root.appendChild(missing);
        }
        if (this.hasSetCodes()) {
            Element set = aDocument.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:set");
            EPPUtil.encodeCompList(aDocument, set, this.setCodes);
            root.appendChild(set);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.profileName = aElement.getAttribute(ATTR_PROFILE_NAME);
        this.status = Status.getStatus(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:verificationCode-1.0", ELM_STATUS));
        Element theMissingElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:verificationCode-1.0", ELM_MISSING);
        this.missingCodes = theMissingElm != null ? EPPUtil.decodeCompList(theMissingElm, "urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:code", EPPVerificationCode.class) : new ArrayList<EPPVerificationCode>();
        Element theSetElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:verificationCode-1.0", ELM_SET);
        this.setCodes = theSetElm != null ? EPPUtil.decodeCompList(theSetElm, "urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:code", EPPVerificationCode.class) : new ArrayList<EPPVerificationCode>();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPVerificationCodeProfile)) {
            cat.error((Object)("EPPVerificationCodeInfData.equals(): " + aObject.getClass().getName() + " not EPPVerificationCodeInfData instance"));
            return false;
        }
        EPPVerificationCodeProfile other = (EPPVerificationCodeProfile)aObject;
        if (!EqualityUtil.equals(this.profileName, other.profileName)) {
            cat.error((Object)"EPPVerificationCodeInfData.equals(): profile not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.status, (Object)other.status)) {
            cat.error((Object)"EPPVerificationCodeInfData.equals(): status not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.missingCodes, other.missingCodes)) {
            cat.error((Object)"EPPVerificationCodeInfData.equals(): missingCodes not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.setCodes, other.setCodes)) {
            cat.error((Object)"EPPVerificationCodeInfData.equals(): setCodes not equal");
            return false;
        }
        return true;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String aProfileName) {
        this.profileName = aProfileName;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status aStatus) {
        this.status = aStatus;
    }

    public boolean hasMissingCodes() {
        return !this.missingCodes.isEmpty();
    }

    public List<EPPVerificationCode> getMissingCodes() {
        return this.missingCodes;
    }

    public void setMissingCodes(List<EPPVerificationCode> aMissingCodes) {
        this.missingCodes = aMissingCodes == null ? new ArrayList<EPPVerificationCode>() : aMissingCodes;
    }

    public void addMissingCode(EPPVerificationCode aMissingCode) {
        this.missingCodes.add(aMissingCode);
    }

    public boolean hasSetCodes() {
        return !this.setCodes.isEmpty();
    }

    public List<EPPVerificationCode> getSetCodes() {
        return this.setCodes;
    }

    public void setSetCodes(List<EPPVerificationCode> aSetCodes) {
        this.setCodes = aSetCodes == null ? new ArrayList<EPPVerificationCode>() : aSetCodes;
    }

    public void addSetCode(EPPVerificationCode aSetCode) {
        this.setCodes.add(aSetCode);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum Status {
        NOT_APPLICABLE("notApplicable"),
        NON_COMPLIANT("nonCompliant"),
        PENDING_COMPLIANCE("pendingCompliance"),
        COMPLIANT("compliant");

        private final String statusStr;

        private Status(String aStatusStr) {
            this.statusStr = aStatusStr;
        }

        public static Status getStatus(String aString) {
            if (aString.equals(Status.NOT_APPLICABLE.statusStr)) {
                return NOT_APPLICABLE;
            }
            if (aString.equals(Status.NON_COMPLIANT.statusStr)) {
                return NON_COMPLIANT;
            }
            if (aString.equals(Status.PENDING_COMPLIANCE.statusStr)) {
                return PENDING_COMPLIANCE;
            }
            if (aString.equals(Status.COMPLIANT.statusStr)) {
                return COMPLIANT;
            }
            throw new InvalidParameterException("Status enum value of " + aString + " is not valid.");
        }

        public String toString() {
            return this.statusStr;
        }
    }
}

