/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPSchemaCachingParser;
import com.verisign.epp.util.EPPXMLErrorHandler;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPSignedCode
implements EPPCodecComponent {
    private static final long serialVersionUID = 3210389145062853193L;
    private static Logger cat = Logger.getLogger((String)EPPSignedCode.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_SIGNED_CODE_LOCALNAME = "signedCode";
    public static final String ELM_SIGNED_CODE = "urn:ietf:params:xml:ns:verificationCode-1.0:signedCode";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ID_VALUE = "signedCode";
    private static XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
    private static final boolean IGNORE_XML_PARSE_EXCEPTION = true;
    private static final boolean DO_NOT_IGNORE_XML_PARSE_EXCEPTION = false;
    private String localName = "signedCode";
    private String attrIdValue = "signedCode";
    private EPPVerificationCode code;
    private Element signedCodeElement = null;

    public EPPSignedCode() {
    }

    public EPPSignedCode(EPPEncodedSignedCodeValue aEncodedSignedCode) {
        EPPEncodedSignedCodeValue encodedSignedCode = aEncodedSignedCode;
        this.code = encodedSignedCode.code;
        this.signedCodeElement = encodedSignedCode.signedCodeElement;
    }

    public EPPSignedCode(EPPVerificationCode aCode) throws EPPEncodeException {
        this.code = aCode;
        this.parseAndSetSignedCodeElement(aCode);
    }

    public EPPSignedCode(String aCode, String aType) throws EPPEncodeException {
        this.code = new EPPVerificationCode(aCode, aType);
        this.parseAndSetSignedCodeElement(this.code);
    }

    public EPPSignedCode(byte[] aSignedCodeArray) throws EPPDecodeException {
        cat.debug((Object)"EPPSignedCode(byte[]): enter");
        this.decode(aSignedCodeArray);
        cat.debug((Object)"EPPSignedCode.decode(byte[]): exit");
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        cat.debug((Object)"EPPSignedCode.decode(Element): enter");
        this.decodeSignedCodeElement(aElement);
        cat.debug((Object)"EPPSignedCode.decode(Element): exit - normal");
    }

    protected void decode(byte[] aSignedCodeArray) throws EPPDecodeException {
        Element elm = this.parseAndGetDocElement(aSignedCodeArray);
        this.initializeObject(elm);
        this.signedCodeElement = elm;
    }

    private void initializeObject(Element aElement) throws EPPDecodeException {
        this.localName = aElement.getLocalName();
        this.attrIdValue = aElement.getAttribute(ATTR_ID);
        this.code = (EPPVerificationCode)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:code", EPPVerificationCode.class);
    }

    private void decodeSignedCodeElement(Element aElement) throws EPPDecodeException {
        this.initializeObject(aElement);
        try {
            this.signedCodeElement = this.parseAndGetDocElement(this.getByteArrayForElement(aElement));
        }
        catch (EPPEncodeException e) {
            throw new EPPDecodeException(e);
        }
    }

    public byte[] encode() throws EPPEncodeException {
        return this.getByteArrayForElement(this.signedCodeElement);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug((Object)"EPPSignedCode.encode(Document): enter");
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPSignedCode.encode(Document)");
        }
        if (this.signedCodeElement == null) {
            throw new EPPEncodeException("Signed code is not decoded properly.");
        }
        Node newAddedNode = aDocument.importNode(this.signedCodeElement, true);
        cat.debug((Object)"EPPSignedCode.encode(Document): exit - normal");
        return (Element)newAddedNode;
    }

    private void validateRequiredAttributes() throws EPPEncodeException {
        if (this.code == null) {
            throw new EPPEncodeException("code is required.");
        }
    }

    private void parseAndSetSignedCodeElement(EPPVerificationCode aCode) throws EPPEncodeException {
        this.code = aCode;
        this.validateRequiredAttributes();
        DocumentImpl document = new DocumentImpl();
        Element root = document.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:" + this.localName);
        root.setAttribute(ATTR_ID, this.attrIdValue);
        root.setIdAttribute(ATTR_ID, true);
        EPPUtil.encodeComp((Document)document, root, this.code);
        document.appendChild(root);
        byte[] xmlBytes = this.getByteArrayForElement(root);
        try {
            this.signedCodeElement = this.parseAndGetDocElement(xmlBytes, true);
        }
        catch (EPPDecodeException e) {
            throw new EPPEncodeException(e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSignedCode clone = (EPPSignedCode)super.clone();
        return clone;
    }

    public void sign(PrivateKey aPrivateKey) throws EPPException {
        cat.debug((Object)"EPPSignedCode.sign(PrivateKey): enter");
        this.sign(aPrivateKey, null);
        cat.debug((Object)"EPPSignedCode.sign(PrivateKey): exit");
    }

    public void sign(PrivateKey aPrivateKey, Certificate[] aCertChain) throws EPPException {
        cat.debug((Object)"EPPSignedCode.sign(PrivateKey, Certificate[]): enter");
        if (aPrivateKey == null) {
            throw new EPPException("EPPSignedCode.sign(PrivateKey, Certificate[]): null aPrivateKey parameter");
        }
        try {
            DigestMethod digestMethod = sigFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            ArrayList<Transform> transforms = new ArrayList<Transform>();
            transforms.add(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference xmlSigRef = sigFactory.newReference("#" + this.attrIdValue, digestMethod, transforms, null, null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(xmlSigRef));
            KeyInfo keyInfo = null;
            if (aCertChain != null) {
                cat.debug((Object)"EPPSignedCode.sign(PrivateKey, Certificate[]): certificate chain passed");
                KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
                ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                for (Certificate cert : aCertChain) {
                    if (cert == null || !(cert instanceof X509Certificate)) {
                        throw new EPPException("EPPSignedCode.sign(PrivateKey, Certificate[]): Null or invalid certificate type");
                    }
                    certChain.add((X509Certificate)cert);
                    cat.debug((Object)("EPPSignedCode.sign(PrivateKey, Certificate[]): Added certificate [" + cert + "] to X509Certificate list"));
                }
                ArrayList<X509Data> certDataList = new ArrayList<X509Data>();
                certDataList.add(keyInfoFactory.newX509Data(certChain));
                keyInfo = keyInfoFactory.newKeyInfo(certDataList);
            } else {
                cat.debug((Object)"EPPSignedCode.sign(PrivateKey, Certificate[]): null certificate chain passed, no certificates added");
            }
            DOMSignContext signContext = new DOMSignContext(aPrivateKey, (Node)this.signedCodeElement);
            signContext.setDefaultNamespacePrefix("dsig");
            XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(signContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            cat.error((Object)("Error signing the EPPSignedCode: " + ex));
            throw new EPPException("EPPSignedCode.sign(PrivateKey, Certificate[]): Error signing the EPPSignedCode");
        }
        cat.debug((Object)"EPPSignedCode.sign(PrivateKey, Certificate[]): exit");
    }

    public boolean validate(PKIXParameters aPKIXParameters) {
        return this.validate(aPKIXParameters, true);
    }

    private Element findSignatureElement() {
        return EPPUtil.getElementByTagNameNS(this.signedCodeElement, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(PKIXParameters aPKIXParameters, boolean aSynchronizePKIXParameters) {
        cat.debug((Object)"validate(PKIXParameters): enter");
        boolean valid = false;
        try {
            Element sigElement = this.findSignatureElement();
            DOMStructure domStructure = new DOMStructure(sigElement);
            XMLSignature signature = sigFactory.unmarshalXMLSignature(domStructure);
            if (signature.getKeyInfo() == null) {
                throw new Exception("No key info found in Signature");
            }
            ArrayList<X509Certificate> certificates = null;
            List<XMLStructure> keyContent = signature.getKeyInfo().getContent();
            for (XMLStructure currInfo : keyContent) {
                if (currInfo instanceof X509Data) {
                    List<?> x509Data = ((X509Data)currInfo).getContent();
                    if (x509Data == null) continue;
                    for (Object currX509Data : x509Data) {
                        if (!(currX509Data instanceof X509Certificate)) continue;
                        if (certificates == null) {
                            certificates = new ArrayList<X509Certificate>();
                        }
                        X509Certificate x509Cert = (X509Certificate)currX509Data;
                        x509Cert.checkValidity();
                        cat.debug((Object)("validate(PKIXParameters): Found X509Certificate [" + x509Cert + "]"));
                        certificates.add(x509Cert);
                    }
                }
                if (certificates == null || certificates.isEmpty()) {
                    throw new Exception("No certificates found in Signature");
                }
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                CertPath certPath = certFactory.generateCertPath((List<? extends Certificate>)certificates);
                CertPathValidator pathValidator = CertPathValidator.getInstance("PKIX");
                if (aSynchronizePKIXParameters) {
                    PKIXParameters pKIXParameters = aPKIXParameters;
                    synchronized (pKIXParameters) {
                        pathValidator.validate(certPath, aPKIXParameters);
                        continue;
                    }
                }
                pathValidator.validate(certPath, aPKIXParameters);
            }
            X509Certificate cert = (X509Certificate)certificates.get(0);
            cat.debug((Object)("validate(PKIXParameters): Getting public key from top certificate [" + cert + "]"));
            PublicKey publicKey = cert.getPublicKey();
            valid = this.validate(sigElement, publicKey);
        }
        catch (Exception ex) {
            cat.error((Object)("validate(PKIXParameters): Error validating the EPPSignedCode: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(PKIXParameters): exit, valid = " + valid));
        return valid;
    }

    public boolean validate(PublicKey aPublicKey) {
        cat.debug((Object)"validate(PublicKey): enter");
        boolean valid = false;
        try {
            Element sigElm = this.findSignatureElement();
            valid = this.validate(sigElm, aPublicKey);
        }
        catch (Exception ex) {
            cat.error((Object)("validate(PublicKey): Error validating the EPPSignedCode: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(PublicKey): exit, valid = " + valid));
        return valid;
    }

    private byte[] getByteArrayForElement(Element aElement) throws EPPEncodeException {
        cat.debug((Object)"EPPSignedCode.getByteArrayForElement(): enter");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(aElement), new StreamResult(os));
        }
        catch (Exception ex) {
            cat.error((Object)("Error encoding signed code to byte[]: " + ex));
            throw new EPPEncodeException("Error encoding signed code to byte[]");
        }
        cat.debug((Object)"EPPSignedCode.getByteArrayForElement(): exit");
        return os.toByteArray();
    }

    private Element parseAndGetDocElement(byte[] aSignedCodeArray) throws EPPDecodeException {
        return this.parseAndGetDocElement(aSignedCodeArray, false);
    }

    private Element parseAndGetDocElement(byte[] aSignedCodeArray, boolean aIgnoreParsingError) throws EPPDecodeException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(aSignedCodeArray);
            EPPSchemaCachingParser parser = new EPPSchemaCachingParser();
            parser.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
            if (!aIgnoreParsingError) {
                parser.setErrorHandler(new EPPXMLErrorHandler());
            }
            Document doc = parser.parse(is);
            Element elm = doc.getDocumentElement();
            elm.setIdAttribute(ATTR_ID, true);
            Element element = elm;
            return element;
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding signed code array: " + ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSignedCode)) {
            cat.error((Object)"EPPSignedCode.equals(): aObject is not an EPPSignedCode");
            return false;
        }
        EPPSignedCode other = (EPPSignedCode)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error((Object)"EPPSignedCode.equals(): code not equal");
            return false;
        }
        return true;
    }

    public String getLocalName() {
        return this.localName;
    }

    public EPPVerificationCode getCode() {
        return this.code;
    }

    public String getCodeValue() {
        return this.code.getCode();
    }

    public String getCodeType() {
        return this.code.getType();
    }

    public String getAttrIdValue() {
        return this.attrIdValue;
    }

    private boolean validate(Element aSigElm, PublicKey aPublicKey) {
        cat.debug((Object)"validate(Element, PublicKey): enter");
        boolean valid = false;
        try {
            DOMValidateContext valContext = new DOMValidateContext(aPublicKey, (Node)aSigElm);
            XMLSignature signature = sigFactory.unmarshalXMLSignature(valContext);
            if (signature.validate(valContext)) {
                valid = true;
            } else {
                valid = false;
                cat.error((Object)("validate(Element, PublicKey): validation status = " + signature.getSignatureValue().validate(valContext)));
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference next = i.next();
                    cat.error((Object)("validate(Element, PublicKey): ref[" + j + "], URI = " + next.getURI() + ", validity status = " + next.validate(valContext)));
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            cat.error((Object)("validate(Element, PublicKey): Error validating the EPPSignedCode: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(Element, PublicKey): exit, valid = " + valid));
        return valid;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

