/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSuggestionAddress
implements EPPCodecComponent {
    private static final long serialVersionUID = -6391796823155355236L;
    static final String ELM_NAME = "suggestion:addr";
    static final String ELM_LOCALNAME = "addr";
    private static final String ELM_ADDRESS_IP = "ip";
    private static final String ATTR_IPV4 = "v4";
    public static final short IPV4 = 0;
    public static final short IPV6 = 1;
    public static final String ATTR_IPV6 = "v6";
    private String name = null;
    private short type = 0;

    public EPPSuggestionAddress() {
        this.name = null;
        this.type = 0;
    }

    public EPPSuggestionAddress(String aName) {
        this.name = aName;
        this.type = 0;
    }

    public EPPSuggestionAddress(String aName, short aType) {
        this.name = aName;
        this.type = aType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setName(String aName, short aType) {
        this.name = aName;
        this.type = aType;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short aType) {
        this.type = aType;
    }

    public String toLogString() {
        return "name=" + this.name + ",type=" + this.type;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("required attribute name is not set");
        }
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.type == 0) {
            root.setAttribute(ELM_ADDRESS_IP, ATTR_IPV4);
        } else if (this.type == 1) {
            root.setAttribute(ELM_ADDRESS_IP, ATTR_IPV6);
        } else {
            throw new EPPEncodeException("Invalid host address type of " + this.type);
        }
        root.appendChild(aDocument.createTextNode(this.name));
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = aElement.getFirstChild().getNodeValue();
        String typeStr = aElement.getAttribute(ELM_ADDRESS_IP);
        if (typeStr == null || typeStr.equals(ATTR_IPV4)) {
            this.type = 0;
        } else if (typeStr.equals(ATTR_IPV6)) {
            this.type = 1;
        } else {
            throw new EPPDecodeException("Invalid host address type of " + typeStr);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSuggestionAddress)) {
            return false;
        }
        EPPSuggestionAddress theComp = (EPPSuggestionAddress)aObject;
        if (this.type != theComp.type) {
            return false;
        }
        return this.name != null ? this.name.equals(theComp.name) : theComp.name == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSuggestionAddress clone = null;
        clone = (EPPSuggestionAddress)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

