/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPLaunchPhase
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchPhase.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String PHASE_SUNRISE = "sunrise";
    public static final String PHASE_LANDRUSH = "landrush";
    public static final String PHASE_CLAIMS = "claims";
    public static final String PHASE_OPEN = "open";
    public static final String PHASE_CUSTOM = "custom";
    public static final String ELM_LOCALNAME = "phase";
    public static final String ELM_NAME = "launch:phase";
    public static final String ATTR_NAME = "name";
    private String phase;
    private String name;

    public EPPLaunchPhase() {
    }

    public EPPLaunchPhase(String aPhase) {
        this.phase = aPhase;
    }

    public EPPLaunchPhase(String aPhase, String aName) {
        this.phase = aPhase;
        this.name = aName;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String aPhase) {
        this.phase = aPhase;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchPhase clone = null;
        clone = (EPPLaunchPhase)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theName = aElement.getAttribute(ATTR_NAME);
        this.name = theName != null && !theName.isEmpty() ? theName : null;
        Node textNode = aElement.getFirstChild();
        if (textNode != null) {
            this.phase = textNode.getNodeValue();
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchPhase.encode(Document)");
        }
        if (this.phase == null) {
            throw new EPPEncodeException("phase is null on in EPPLaunchPhase.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        if (this.name != null) {
            root.setAttribute(ATTR_NAME, this.name);
        }
        Text phaseText = aDocument.createTextNode(this.phase);
        root.appendChild(phaseText);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchPhase)) {
            return false;
        }
        EPPLaunchPhase other = (EPPLaunchPhase)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPLaunchPhase.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error((Object)"EPPLaunchPhase.equals(): phase not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

