/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.management;

import com.codestudio.management.DataSourceServiceMBean;
import com.codestudio.management.ObjectPoolService;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.JDBCPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.SQLManager;
import javax.management.MBeanRegistration;

public class DataSourceService
extends ObjectPoolService
implements DataSourceServiceMBean,
MBeanRegistration {
    private JDBCPoolMetaData jdbcMeta;

    public DataSourceService() {
        this.metadata = new JDBCPoolMetaData();
        this.jdbcMeta = (JDBCPoolMetaData)this.metadata;
    }

    public void start() throws Exception {
        SQLManager sQLManager = SQLManager.getInstance();
        JDBCPool jDBCPool = sQLManager.createPool(this.jdbcMeta);
        jDBCPool.log("PoolMan DataSourceService: Created JDBC Connection Pool named: " + this.getDbname());
        this.available = true;
    }

    public void stop() throws Exception {
        this.available = false;
        SQLManager sQLManager = SQLManager.getInstance();
        JDBCPool jDBCPool = (JDBCPool)sQLManager.getPool(this.getDbname());
        sQLManager.removePool(this.getDbname());
        jDBCPool.log("PoolMan DataSourceService: Destroying JDBC Connection Pool " + this.getDbname());
        jDBCPool.closeAllResources();
        jDBCPool = null;
    }

    public boolean isRunning() {
        return this.available;
    }

    public String getDriver() {
        return this.jdbcMeta.getDriver();
    }

    public void setDriver(String string) {
        this.jdbcMeta.setDriver(string);
    }

    public String getURL() {
        return this.jdbcMeta.getURL();
    }

    public void setURL(String string) {
        this.jdbcMeta.setURL(string);
    }

    public String getUserName() {
        return this.jdbcMeta.getUserName();
    }

    public void setUserName(String string) {
        this.jdbcMeta.setUserName(string);
    }

    public String getPassword() {
        return this.jdbcMeta.getPassword();
    }

    public void setPassword(String string) {
        this.jdbcMeta.setPassword(string);
    }

    public String getDbname() {
        return this.jdbcMeta.getName();
    }

    public void setDbname(String string) {
        this.jdbcMeta.setName(string);
    }

    public String getJNDIName() {
        return this.jdbcMeta.getJNDIName();
    }

    public void setJNDIName(String string) {
        this.jdbcMeta.setJNDIName(string);
    }

    public boolean isNativeResults() {
        return this.jdbcMeta.isNativeResults();
    }

    public void setNativeResults(boolean bl) {
        this.jdbcMeta.setNativeResults(bl);
    }

    public boolean isDataSourceDeployed() {
        JDBCPool jDBCPool = (JDBCPool)SQLManager.getInstance().getPool(this.getDbname());
        return jDBCPool.isDataSourceDeployed();
    }

    public boolean isPoolPreparedStatements() {
        return this.jdbcMeta.isPoolPreparedStatements();
    }

    public void setPoolPreparedStatements(boolean bl) {
        this.jdbcMeta.setPoolPreparedStatements(bl);
    }

    public String getValidationQuery() {
        return this.jdbcMeta.getValidationQuery();
    }

    public void setValidationQuery(String string) {
        this.jdbcMeta.setValidationQuery(string);
    }

    public String getInitialPoolSQL() {
        return this.jdbcMeta.getInitialPoolSQL();
    }

    public void setInitialPoolSQL(String string) {
        this.jdbcMeta.setInitialPoolSQL(string);
    }

    public String getInitialConnectionSQL() {
        return this.jdbcMeta.getInitialConnectionSQL();
    }

    public void setInitialConnectionSQL(String string) {
        this.jdbcMeta.setInitialConnectionSQL(string);
    }

    public boolean isRemoveOnExceptions() {
        return this.jdbcMeta.isRemoveOnExceptions();
    }

    public void setRemoveOnExceptions(boolean bl) {
        this.jdbcMeta.setRemoveOnExceptions(bl);
    }

    public int getInitialConnections() {
        return this.getInitialObjects();
    }

    public void setInitialConnections(int n) {
        this.setInitialObjects(n);
    }

    public int getConnectionTimeout() {
        return this.getObjectTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.setObjectTimeout(n);
    }

    public int getTransactionTimeout() {
        return this.jdbcMeta.getTransactionTimeout();
    }

    public void setTransactionTimeout(int n) {
        this.jdbcMeta.setTransactionTimeout(n);
    }

    public String getTxIsolationLevel() {
        return this.jdbcMeta.getTxIsolationLevel();
    }

    public void setTxIsolationLevel(String string) {
        this.jdbcMeta.setTxIsolationLevel(string);
    }

    public boolean isCacheEnabled() {
        return this.jdbcMeta.isCacheEnabled();
    }

    public void setCacheEnabled(boolean bl) {
        this.jdbcMeta.setCacheEnabled(bl);
    }

    public int getCacheSize() {
        return this.jdbcMeta.getCacheSize();
    }

    public void setCacheSize(int n) {
        this.jdbcMeta.setCacheSize(n);
    }

    public int getCacheRefreshInterval() {
        return this.jdbcMeta.getCacheRefreshInterval();
    }

    public void setCacheRefreshInterval(int n) {
        this.jdbcMeta.setCacheRefreshInterval(n);
    }

    public int getAvailableConnections() {
        ObjectPool objectPool = SQLManager.getInstance().getPool(this.getDbname());
        return objectPool.numCheckedInObjects();
    }

    public int getUnavailableConnections() {
        ObjectPool objectPool = SQLManager.getInstance().getPool(this.getDbname());
        return objectPool.numCheckedOutObjects();
    }

    public int getTotalConnections() {
        ObjectPool objectPool = SQLManager.getInstance().getPool(this.getDbname());
        return objectPool.numTotalObjects();
    }
}

