/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.sql;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class PoolManResultSetMetaData
implements ResultSetMetaData,
Serializable {
    private int _columnCount;
    private String[] _columnTypeName;
    private String[] _columnClassName;
    private int[] _scale;
    private String[] _columnLabel;
    private boolean[] _autoIncrement;
    private int[] _columnDisplaySize;
    private String[] _catalogName;
    private String[] _columnName;
    private boolean[] _writable;
    private boolean[] _searchable;
    private int[] _columnType;
    private boolean[] _currency;
    private String[] _tableName;
    private int[] _nullable;
    private boolean[] _signed;
    private boolean[] _readOnly;
    private boolean[] _definitelyWritable;
    private int[] _precision;
    private String[] _schemaName;
    private boolean[] _caseSensitive;
    private String _sqlReason;
    private String _sqlState;
    private int _sqlVendorCode;

    public static ResultSetMetaData getCopy(ResultSetMetaData resultSetMetaData) throws SQLException {
        if (resultSetMetaData instanceof PoolManResultSetMetaData) {
            return resultSetMetaData;
        }
        return new PoolManResultSetMetaData(resultSetMetaData);
    }

    private PoolManResultSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this._columnCount = resultSetMetaData.getColumnCount();
        this._columnTypeName = new String[this._columnCount];
        this._columnClassName = new String[this._columnCount];
        this._scale = new int[this._columnCount];
        this._columnLabel = new String[this._columnCount];
        this._autoIncrement = new boolean[this._columnCount];
        this._columnDisplaySize = new int[this._columnCount];
        this._catalogName = new String[this._columnCount];
        this._columnName = new String[this._columnCount];
        this._writable = new boolean[this._columnCount];
        this._searchable = new boolean[this._columnCount];
        this._columnType = new int[this._columnCount];
        this._currency = new boolean[this._columnCount];
        this._tableName = new String[this._columnCount];
        this._nullable = new int[this._columnCount];
        this._signed = new boolean[this._columnCount];
        this._readOnly = new boolean[this._columnCount];
        this._definitelyWritable = new boolean[this._columnCount];
        this._precision = new int[this._columnCount];
        this._schemaName = new String[this._columnCount];
        this._caseSensitive = new boolean[this._columnCount];
        int n = 0;
        while (n < this._columnCount) {
            this._columnTypeName[n] = resultSetMetaData.getColumnTypeName(n + 1);
            if (this._columnClassName != null) {
                try {
                    this._columnClassName[n] = resultSetMetaData.getColumnClassName(n + 1);
                }
                catch (SQLException sQLException) {
                    this._columnClassName = null;
                    this._sqlReason = sQLException.getMessage();
                    this._sqlState = sQLException.getSQLState();
                    this._sqlVendorCode = sQLException.getErrorCode();
                }
                catch (Throwable throwable) {
                    this._columnClassName = null;
                }
            }
            this._scale[n] = resultSetMetaData.getScale(n + 1);
            this._columnLabel[n] = resultSetMetaData.getColumnLabel(n + 1);
            this._autoIncrement[n] = resultSetMetaData.isAutoIncrement(n + 1);
            this._columnDisplaySize[n] = resultSetMetaData.getColumnDisplaySize(n + 1);
            try {
                this._catalogName[n] = resultSetMetaData.getCatalogName(n + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._catalogName[n] == null) {
                this._catalogName[n] = "";
            }
            this._columnName[n] = resultSetMetaData.getColumnName(n + 1);
            this._writable[n] = resultSetMetaData.isWritable(n + 1);
            this._searchable[n] = resultSetMetaData.isSearchable(n + 1);
            this._columnType[n] = resultSetMetaData.getColumnType(n + 1);
            this._currency[n] = resultSetMetaData.isCurrency(n + 1);
            try {
                this._tableName[n] = resultSetMetaData.getTableName(n + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._tableName[n] == null) {
                this._tableName[n] = "";
            }
            this._nullable[n] = resultSetMetaData.isNullable(n + 1);
            this._signed[n] = resultSetMetaData.isSigned(n + 1);
            this._readOnly[n] = resultSetMetaData.isReadOnly(n + 1);
            this._definitelyWritable[n] = resultSetMetaData.isDefinitelyWritable(n + 1);
            this._precision[n] = resultSetMetaData.getPrecision(n + 1);
            try {
                this._schemaName[n] = resultSetMetaData.getSchemaName(n + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._schemaName[n] == null) {
                this._schemaName[n] = "";
            }
            this._caseSensitive[n] = resultSetMetaData.isCaseSensitive(n + 1);
            ++n;
        }
    }

    public int getColumnCount() throws SQLException {
        return this._columnCount;
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this._columnTypeName[n - 1];
    }

    public String getColumnClassName(int n) throws SQLException {
        if (this._columnClassName == null) {
            throw new SQLException(this._sqlReason, this._sqlState, this._sqlVendorCode);
        }
        return this._columnClassName[n - 1];
    }

    public int getScale(int n) throws SQLException {
        return this._scale[n - 1];
    }

    public String getColumnLabel(int n) throws SQLException {
        return this._columnLabel[n - 1];
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return this._autoIncrement[n - 1];
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this._columnDisplaySize[n - 1];
    }

    public String getCatalogName(int n) throws SQLException {
        return this._catalogName[n - 1];
    }

    public String getColumnName(int n) throws SQLException {
        return this._columnName[n - 1];
    }

    public boolean isWritable(int n) throws SQLException {
        return this._writable[n - 1];
    }

    public boolean isSearchable(int n) throws SQLException {
        return this._searchable[n - 1];
    }

    public int getColumnType(int n) throws SQLException {
        return this._columnType[n - 1];
    }

    public boolean isCurrency(int n) throws SQLException {
        return this._currency[n - 1];
    }

    public String getTableName(int n) throws SQLException {
        return this._tableName[n - 1];
    }

    public int isNullable(int n) throws SQLException {
        return this._nullable[n - 1];
    }

    public boolean isSigned(int n) throws SQLException {
        return this._signed[n - 1];
    }

    public boolean isReadOnly(int n) throws SQLException {
        return this._readOnly[n - 1];
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this._definitelyWritable[n - 1];
    }

    public int getPrecision(int n) throws SQLException {
        return this._precision[n - 1];
    }

    public String getSchemaName(int n) throws SQLException {
        return this._schemaName[n - 1];
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return this._caseSensitive[n - 1];
    }
}

