/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.sql;

import com.codestudio.util.SQLManager;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class PoolManDataSource
implements DataSource,
ConnectionPoolDataSource,
Referenceable,
ObjectFactory {
    private String poolName;
    private String jndiName;
    private PrintWriter logger;
    private int loginTimeout;

    public PoolManDataSource() {
    }

    public PoolManDataSource(String string, String string2) {
        this();
        this.poolName = string;
        this.jndiName = string2;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public Connection getConnection() throws SQLException {
        return SQLManager.getInstance().requestConnection(this.poolName);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        SQLManager.getInstance().checkCredentials(this.poolName, string, string2);
        return this.getConnection();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getConnection());
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return (PooledConnection)((Object)this.getConnection(string, string2));
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public String toString() {
        return "PoolManDataSource:[JNDIName:" + this.jndiName + ",PoolName:" + this.poolName + "]";
    }

    public Reference getReference() {
        Reference reference = new Reference("com.codestudio.sql.PoolManDataSource", "com.codestudio.sql.PoolManDataSource", null);
        reference.add(new StringRefAddr("dbname", this.poolName));
        reference.add(new StringRefAddr("jndiname", this.jndiName));
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        PoolManDataSource poolManDataSource = null;
        Reference reference = (Reference)object;
        if (reference.getClassName().equals("com.codestudio.sql.PoolManDataSource")) {
            PoolManDataSource poolManDataSource2;
            String string = (String)reference.get("dbname").getContent();
            String string2 = (String)reference.get("jndiname").getContent();
            poolManDataSource = poolManDataSource2 = new PoolManDataSource(string, string2);
        }
        return poolManDataSource;
    }
}

