/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EnvException;
import com.verisign.epp.util.Environment;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;

public abstract class EPPEnv
extends Environment {
    public static final int LOG_BASIC = 0;
    public static final int LOG_CFG_FILE = 1;
    public static final int LOG_CUSTOM = 2;
    public static final String POOLMAN_SERVER_PREFIX = "PoolMan.Server.";
    public static final String POOLMAN_XMLSIGNATURE_PREFIX = "PoolMan.XMLSignature.";
    public static final String POOLMAN_CLIENT_PREFIX = "PoolMan.Client.";

    public void initialize(String newConfigFileName, ClassLoader aClassLoader) throws EPPEnvException {
        Object st = null;
        String[] listArr = new String[]{"EPP.ServerName", "EPP.ServerPort", "EPP.ConTimeOut", "EPP.MapFactories", "EPP.ProtocolExtensions", "EPP.CmdRspExtensions", "EPP.ServerEventHandlers", "EPP.LogMode"};
        try {
            this.envInitialize(newConfigFileName, aClassLoader);
        }
        catch (EnvException myException) {
            throw new EPPEnvException("Environment Exception : (" + newConfigFileName + ") " + myException.getMessage());
        }
        try {
            for (int i = 0; i < listArr.length; ++i) {
                if (EPPEnv.getEnv(listArr[i]) != null) continue;
                throw new EPPEnvException("EPPEnv : " + listArr[i] + " is Missing from Configuration file");
            }
        }
        catch (EnvException myException) {
            throw new EPPEnvException("Environment Exception : " + myException.getMessage());
        }
    }

    public void initialize(String newConfigFileName) throws EPPEnvException {
        Object st = null;
        String[] listArr = new String[]{"EPP.ServerName", "EPP.ServerPort", "EPP.ConTimeOut", "EPP.MapFactories", "EPP.ProtocolExtensions", "EPP.CmdRspExtensions", "EPP.LogMode"};
        try {
            this.envInitialize(newConfigFileName);
        }
        catch (EnvException myException) {
            throw new EPPEnvException("Environment Exception : (" + newConfigFileName + ") " + myException.getMessage());
        }
        try {
            for (int i = 0; i < listArr.length; ++i) {
                if (EPPEnv.getEnv(listArr[i]) != null) continue;
                throw new EPPEnvException("EPPEnv : " + listArr[i] + " is Missing from Configuration file");
            }
        }
        catch (EnvException myException) {
            throw new EPPEnvException("Environment Exception : " + myException.getMessage());
        }
    }

    public static String getClientHost() {
        return Environment.getOption("EPP.ClientHost");
    }

    public static String getServerName() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.ServerName");
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return st;
    }

    public static String getGreetingServerName() {
        String st = "EPP Server Stub";
        try {
            st = Environment.getEnv("EPP.GreetingServerName");
        }
        catch (EnvException envException) {
            // empty catch block
        }
        return st;
    }

    public static int getServerPort() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.ServerPort");
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return new Integer(st);
    }

    public static int getConTimeOut() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.ConTimeOut");
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return new Integer(st);
    }

    public static String getProxyServerLocator() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.ProxyServersLocator");
        }
        catch (EnvException ex) {
            throw new EPPEnvException("EPP Environment Exception : " + ex.getMessage());
        }
        return st;
    }

    public static String getProxyServers() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.ProxyServers");
        }
        catch (EnvException ex) {
            throw new EPPEnvException("EPP Environment Exception : " + ex.getMessage());
        }
        return st;
    }

    public static boolean getProxyServersRandomize() throws EPPEnvException {
        String st = null;
        st = Environment.getOption("EPP.ProxyServersRandomize");
        if (st != null) {
            return new Boolean(st);
        }
        return true;
    }

    public static String getClientSocketName() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.ClientSocketName");
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return st;
    }

    public static int getLogMode() {
        String cfgMode = Environment.getProperty("EPP.LogMode", "BASIC");
        if (cfgMode.equalsIgnoreCase("BASIC")) {
            return 0;
        }
        if (cfgMode.equalsIgnoreCase("CFGFILE")) {
            return 1;
        }
        if (cfgMode.equalsIgnoreCase("CUSTOM")) {
            return 2;
        }
        return -1;
    }

    public static Level getLogLevel() throws EPPEnvException {
        String st = Environment.getOption("EPP.LogLevel");
        Level ret = null;
        if (st == null) {
            return null;
        }
        if ((st = st.toUpperCase()).equals("DEBUG")) {
            ret = Level.DEBUG;
        } else if (st.equals("INFO")) {
            ret = Level.INFO;
        } else if (st.equals("WARN")) {
            ret = Level.WARN;
        } else if (st.equals("ERROR")) {
            ret = Level.ERROR;
        } else if (st.equals("FATAL")) {
            ret = Level.FATAL;
        } else {
            throw new EPPEnvException("Log level " + st + " is invalid");
        }
        return ret;
    }

    public static String getLogFile() throws EPPEnvException {
        return Environment.getProperty("EPP.LogFile");
    }

    public static String getLogCfgFile() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.LogCfgFile");
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return st;
    }

    public static Long getLogCfgFileWatch() throws EPPEnvException {
        Long ret = null;
        try {
            String configAndWatch = Environment.getProperty("EPP.LogCfgFileWatch");
            if (configAndWatch != null) {
                ret = new Long(Environment.getProperty("EPP.LogCfgFileWatch"));
            }
        }
        catch (NumberFormatException e) {
            throw new EPPEnvException("NumberFormatException converting EPP.LogCfgFileWatch to Long: " + e);
        }
        return ret;
    }

    public static String getServerSocketName() throws EPPEnvException {
        String st = null;
        try {
            st = Environment.getEnv("EPP.ServerSocketName");
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return st;
    }

    public static Vector getMapFactories() throws EPPEnvException {
        Vector<Object> ret = new Vector<Object>();
        try {
            String setting = Environment.getEnv("EPP.MapFactories");
            StringTokenizer tokenizer = new StringTokenizer(setting);
            while (tokenizer.hasMoreElements()) {
                ret.addElement(tokenizer.nextElement());
            }
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return ret;
    }

    public static Vector getProtocolExtensions() throws EPPEnvException {
        Vector<Object> ret = new Vector<Object>();
        try {
            String setting = Environment.getEnv("EPP.ProtocolExtensions");
            StringTokenizer tokenizer = new StringTokenizer(setting);
            while (tokenizer.hasMoreElements()) {
                ret.addElement(tokenizer.nextElement());
            }
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return ret;
    }

    public static Vector getCmdResponseExtensions() throws EPPEnvException {
        Vector<Object> ret = new Vector<Object>();
        try {
            String setting = Environment.getEnv("EPP.CmdRspExtensions");
            StringTokenizer tokenizer = new StringTokenizer(setting);
            while (tokenizer.hasMoreElements()) {
                ret.addElement(tokenizer.nextElement());
            }
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return ret;
    }

    public static Vector getServerEventHandlers() throws EPPEnvException {
        Vector<Object> ret = new Vector<Object>();
        try {
            String setting = Environment.getEnv("EPP.ServerEventHandlers");
            StringTokenizer tokenizer = new StringTokenizer(setting);
            while (tokenizer.hasMoreElements()) {
                ret.addElement(tokenizer.nextElement());
            }
        }
        catch (EnvException myException) {
            throw new EPPEnvException("EPP Environment Exception : " + myException.getMessage());
        }
        return ret;
    }

    public static String getServerEPPAssembler() {
        return Environment.getOption("EPP.ServerAssembler");
    }

    public static String getSSLProtocol() {
        return Environment.getOption("EPP.SSLProtocol");
    }

    public static String[] getSSLEnabledProtocols() {
        String[] theProtocols = null;
        String thePropValue = Environment.getOption("EPP.SSLEnabledProtocols");
        if (thePropValue != null && thePropValue.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(thePropValue);
            int numProtocols = tokenizer.countTokens();
            theProtocols = new String[numProtocols];
            for (int i = 0; i < numProtocols; ++i) {
                theProtocols[i] = tokenizer.nextToken();
            }
        }
        return theProtocols;
    }

    public static String getSSLKeyManager() {
        return Environment.getOption("EPP.SSLKeyManager");
    }

    public static String getKeyStore() {
        return Environment.getOption("EPP.SSLKeyStore");
    }

    public static String getSSLKeyFileName() {
        return Environment.getOption("EPP.SSLKeyFileName");
    }

    public static String getSSLTrustStoreFileName() {
        return Environment.getOption("EPP.SSLTrustStoreFileName");
    }

    public static String getSSLTrustStorePassPhrase() {
        return Environment.getOption("EPP.SSLTrustStorePassPhrase");
    }

    public static String getSSLDebug() {
        return Environment.getProperty("javax.net.debug", "none");
    }

    public static String[] getSSLEnabledCipherSuites() {
        String[] theSSLEnabledCipherSuites = null;
        String theValue = Environment.getOption("EPP.SSLEnabledCipherSuites");
        if (theValue != null && theValue.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(theValue);
            int numSSLEnabledCipherSuites = tokenizer.countTokens();
            theSSLEnabledCipherSuites = new String[numSSLEnabledCipherSuites];
            for (int i = 0; i < numSSLEnabledCipherSuites; ++i) {
                theSSLEnabledCipherSuites[i] = tokenizer.nextToken();
            }
        }
        return theSSLEnabledCipherSuites;
    }

    public static String getSSLPassPhrase() {
        return Environment.getOption("EPP.SSLPassPhrase");
    }

    public static String getSSLKeyPassPhrase() {
        return Environment.getOption("EPP.SSLKeyPassPhrase");
    }

    public static int getServerParserInitObjs() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("initialObjects").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1;
        }
        return new Integer(opt);
    }

    public static int getServerParserMinSize() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("minimumSize").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 0;
        }
        return new Integer(opt);
    }

    public static int getServerParserMaxSize() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("maximumSize").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return Integer.MAX_VALUE;
        }
        return new Integer(opt);
    }

    public static boolean getServerParserMaxSoft() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("maximumSoft").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return true;
        }
        return new Boolean(opt);
    }

    public static int getServerParserObjTimeout() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("objectTimeout").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1200;
        }
        return new Integer(opt);
    }

    public static int getServerParserUserTimeout() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("userTimeout").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1200;
        }
        return new Integer(opt);
    }

    public static int getServerParserSkimmerFreq() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("skimmerFrequency").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 660;
        }
        return new Integer(opt);
    }

    public static int getServerParserShrinkBy() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("shrinkBy").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 5;
        }
        return new Integer(opt);
    }

    public static String getServerParserLogFile() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("logFile").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return new StringBuffer(POOLMAN_SERVER_PREFIX).append("log").toString();
        }
        return opt;
    }

    public static boolean getServerParserDebug() {
        String str = new StringBuffer(POOLMAN_SERVER_PREFIX).append("debugging").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return false;
        }
        return new Boolean(opt);
    }

    public static int getXMLSignatureParserInitObjs() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("initialObjects").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1;
        }
        return new Integer(opt);
    }

    public static int getXMLSignatureParserMinSize() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("minimumSize").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 0;
        }
        return new Integer(opt);
    }

    public static int getXMLSignatureParserMaxSize() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("maximumSize").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return Integer.MAX_VALUE;
        }
        return new Integer(opt);
    }

    public static boolean getXMLSignatureParserMaxSoft() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("maximumSoft").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return true;
        }
        return new Boolean(opt);
    }

    public static int getXMLSignatureParserObjTimeout() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("objectTimeout").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1200;
        }
        return new Integer(opt);
    }

    public static int getXMLSignatureParserUserTimeout() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("userTimeout").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1200;
        }
        return new Integer(opt);
    }

    public static int getXMLSignatureParserSkimmerFreq() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("skimmerFrequency").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 660;
        }
        return new Integer(opt);
    }

    public static int getXMLSignatureParserShrinkBy() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("shrinkBy").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 5;
        }
        return new Integer(opt);
    }

    public static String getXMLSignatureParserLogFile() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("logFile").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("log").toString();
        }
        return opt;
    }

    public static boolean getXMLSignatureParserDebug() {
        String str = new StringBuffer(POOLMAN_XMLSIGNATURE_PREFIX).append("debugging").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return false;
        }
        return new Boolean(opt);
    }

    public static int getClientParserInitObjs() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("initialObjects").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1;
        }
        return new Integer(opt);
    }

    public static int getClientParserMinSize() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("minimumSize").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 0;
        }
        return new Integer(opt);
    }

    public static int getClientParserMaxSize() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("maximumSize").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return Integer.MAX_VALUE;
        }
        return new Integer(opt);
    }

    public static boolean getClientParserMaxSoft() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("maximumSoft").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return true;
        }
        return new Boolean(opt);
    }

    public static int getClientParserObjTimeout() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("objectTimeout").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1200;
        }
        return new Integer(opt);
    }

    public static int getClientParserUserTimeout() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("userTimeout").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 1200;
        }
        return new Integer(opt);
    }

    public static int getClientParserSkimmerFreq() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("skimmerFrequency").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 660;
        }
        return new Integer(opt);
    }

    public static int getClientParserShrinkBy() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("shrinkBy").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return 5;
        }
        return new Integer(opt);
    }

    public static String getClientParserLogFile() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("logFile").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return new StringBuffer(POOLMAN_CLIENT_PREFIX).append("log").toString();
        }
        return opt;
    }

    public static boolean getClientParserDebug() {
        String str = new StringBuffer(POOLMAN_CLIENT_PREFIX).append("debugging").toString();
        String opt = Environment.getOption(str);
        if (opt == null) {
            return false;
        }
        return new Boolean(opt);
    }

    public static Vector getPollHandlers() throws EPPEnvException {
        Vector<Object> ret = new Vector<Object>();
        try {
            String setting = Environment.getEnv("EPP.PollHandlers");
            StringTokenizer tokenizer = new StringTokenizer(setting);
            while (tokenizer.hasMoreElements()) {
                ret.addElement(tokenizer.nextElement());
            }
        }
        catch (EnvException envException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean getValidating() {
        boolean ret = false;
        try {
            String setting = Environment.getEnv("EPP.Validating");
            ret = new Boolean(setting);
        }
        catch (EnvException envException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean getFullSchemaChecking() {
        boolean ret = false;
        try {
            String setting = Environment.getEnv("EPP.FullSchemaChecking");
            ret = new Boolean(setting);
        }
        catch (EnvException envException) {
            // empty catch block
        }
        return ret;
    }
}

