/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.fee.v06.EPPFeeInfo;
import com.verisign.epp.codec.fee.v08.EPPFeeCreate;
import com.verisign.epp.codec.fee.v08.EPPFeeUpdate;
import com.verisign.epp.codec.fee.v09.EPPFeeCheck;
import com.verisign.epp.codec.fee.v09.EPPFeeRenew;
import com.verisign.epp.codec.fee.v09.EPPFeeTransfer;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.serverstub.v06.FeeV06DomainHandler;
import com.verisign.epp.serverstub.v07.FeeV07DomainHandler;
import com.verisign.epp.serverstub.v08.FeeV08DomainHandler;
import com.verisign.epp.serverstub.v09.FeeV09DomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class FeeDomainHandler
extends DomainHandler {
    private static Logger cat = Logger.getLogger((String)FeeDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    FeeV06DomainHandler v06SubHandler = new FeeV06DomainHandler();
    FeeV07DomainHandler v07SubHandler = new FeeV07DomainHandler();
    FeeV08DomainHandler v08SubHandler = new FeeV08DomainHandler();
    FeeV09DomainHandler v09SubHandler = new FeeV09DomainHandler();

    @Override
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPDomainCheckCmd theCommand = (EPPDomainCheckCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainCheck(aEvent, aData);
        if (theCommand.hasExtension(com.verisign.epp.codec.fee.v06.EPPFeeCheck.class)) {
            this.v06SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v07.EPPFeeCheck.class)) {
            this.v07SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v08.EPPFeeCheck.class)) {
            this.v08SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(EPPFeeCheck.class)) {
            this.v09SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainCheck: fee check = null");
            System.out.println("doDomainCheck: fee check = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        if (theCommand.hasExtension(EPPFeeInfo.class)) {
            this.v06SubHandler.doDomainInfo(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v07.EPPFeeInfo.class)) {
            this.v07SubHandler.doDomainInfo(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainInfo: fee info = null");
            System.out.println("doDomainInfo: fee info = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        if (theCommand.hasExtension(com.verisign.epp.codec.fee.v06.EPPFeeCreate.class)) {
            this.v06SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v07.EPPFeeCreate.class)) {
            this.v07SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(EPPFeeCreate.class)) {
            this.v08SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v09.EPPFeeCreate.class)) {
            this.v09SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainCreate: fee create = null");
            System.out.println("doDomainCreate: fee create = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        EPPDomainDeleteCmd theCommand = (EPPDomainDeleteCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainDelete(aEvent, aData);
        SessionData theSessionData = (SessionData)aData;
        boolean hasV06ExtService = false;
        boolean hasV07ExtService = false;
        boolean hasV08ExtService = false;
        boolean hasV09ExtService = false;
        Enumeration extSvcEnum = theSessionData.getLoginCmd().getExtensionServices().elements();
        while (extSvcEnum.hasMoreElements()) {
            EPPService theExtService = (EPPService)extSvcEnum.nextElement();
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.6")) {
                hasV06ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.7")) {
                hasV07ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.8")) {
                hasV08ExtService = true;
            }
            if (!theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.9")) continue;
            hasV09ExtService = true;
        }
        if (hasV06ExtService) {
            this.v06SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (hasV07ExtService) {
            this.v07SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (hasV08ExtService) {
            this.v08SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (hasV09ExtService) {
            this.v09SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (!hasV06ExtService && !hasV07ExtService & !hasV08ExtService && !hasV09ExtService) {
            cat.info((Object)"doDomainDelete: fee extension not supported by client");
            System.out.println("doDomainDelete: fee extension not supported by client");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPDomainRenewCmd theCommand = (EPPDomainRenewCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainRenew(aEvent, aData);
        if (theCommand.hasExtension(com.verisign.epp.codec.fee.v06.EPPFeeRenew.class)) {
            this.v06SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v07.EPPFeeRenew.class)) {
            this.v07SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v08.EPPFeeRenew.class)) {
            this.v08SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(EPPFeeRenew.class)) {
            this.v09SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainRenew: fee renew = null");
            System.out.println("doDomainRenew: fee renew = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theCommand = (EPPDomainTransferCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainTransfer(aEvent, aData);
        SessionData theSessionData = (SessionData)aData;
        boolean hasV06ExtService = false;
        boolean hasV07ExtService = false;
        boolean hasV08ExtService = false;
        boolean hasV09ExtService = false;
        Enumeration extSvcEnum = theSessionData.getLoginCmd().getExtensionServices().elements();
        while (extSvcEnum.hasMoreElements()) {
            EPPService theExtService = (EPPService)extSvcEnum.nextElement();
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.6")) {
                hasV06ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.7")) {
                hasV07ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.8")) {
                hasV08ExtService = true;
            }
            if (!theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.9")) continue;
            hasV09ExtService = true;
        }
        if (theCommand.getOp().equals("query")) {
            if (hasV06ExtService) {
                this.v06SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (hasV07ExtService) {
                this.v07SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (hasV08ExtService) {
                this.v08SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (hasV09ExtService) {
                this.v09SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (!(hasV06ExtService || hasV07ExtService || hasV08ExtService || hasV09ExtService)) {
                cat.info((Object)"doDomainTransfer: fee extension not supported by client");
                System.out.println("doDomainTransfer: fee extension not supported by client");
            }
        } else if (theCommand.getOp().equals("request")) {
            if (theCommand.hasExtension(com.verisign.epp.codec.fee.v06.EPPFeeTransfer.class)) {
                this.v06SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v07.EPPFeeTransfer.class)) {
                this.v07SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v08.EPPFeeTransfer.class)) {
                this.v08SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else if (theCommand.hasExtension(EPPFeeTransfer.class)) {
                this.v09SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else {
                cat.info((Object)"doDomainTransfer: fee transfer request = null");
                System.out.println("doDomainTransfer: fee transfer request = null");
            }
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        if (theCommand.hasExtension(com.verisign.epp.codec.fee.v06.EPPFeeUpdate.class)) {
            this.v06SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v07.EPPFeeUpdate.class)) {
            this.v07SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(EPPFeeUpdate.class)) {
            this.v08SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v09.EPPFeeUpdate.class)) {
            this.v09SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainUpdate: fee update = null");
            System.out.println("doDomainUpdate: fee update = null");
        }
        return theEventResponse;
    }
}

