/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPPooledGenericSession;
import com.verisign.epp.pool.EPPPooledSession;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSessionPoolableFactory
implements PoolableObjectFactory {
    private static Logger log = Logger.getLogger((String)EPPSessionPoolableFactory.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String clientId;
    private String password;
    private long absoluteTimeout;
    private long idleTimeout;
    private String serverName;
    private Integer serverPort;
    private String clientHost = null;
    private EPPSSLContext sslContext = null;

    public EPPSessionPoolableFactory() {
        this.clientId = null;
        this.password = null;
        this.absoluteTimeout = -1L;
        this.idleTimeout = -1L;
    }

    public EPPSessionPoolableFactory(String aClientId, String aPassword, long aAbsoluteTimeout, long aIdleTimeout) {
        this.clientId = aClientId;
        this.password = aPassword;
        this.absoluteTimeout = aAbsoluteTimeout;
        this.idleTimeout = aIdleTimeout;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public void setAbsoluteTimeout(long aAbsoluteTimeout) {
        this.absoluteTimeout = aAbsoluteTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long aIdleTimeout) {
        this.idleTimeout = aIdleTimeout;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer aServerPort) {
        this.serverPort = aServerPort;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String aClientHost) {
        this.clientHost = aClientHost;
    }

    public EPPSSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(EPPSSLContext aSSLContext) {
        this.sslContext = aSSLContext;
    }

    public void activateObject(Object aSession) throws Exception {
    }

    public void destroyObject(Object aSession) throws Exception {
        log.debug((Object)("destroyObject(): enter, session id = " + aSession));
        EPPSession theSession = (EPPSession)aSession;
        try {
            log.debug((Object)"destroyObject(): enter, calling end session");
            theSession.endSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object makeObject() throws Exception {
        log.debug((Object)"makeObject(): enter");
        EPPSession theSession = this.makeSession();
        log.debug((Object)("makeObject(): Make session with id = " + theSession));
        theSession.setClientID(this.clientId);
        theSession.setPassword(this.password);
        log.debug((Object)("makeObject(): establishing session, with session class " + theSession.getClass().getName()));
        try {
            theSession.initSession();
            log.debug((Object)("makeObject(): established session, with session class " + theSession.getClass().getName()));
        }
        catch (EPPCommandException ex) {
            log.error((Object)("makeObject(): error initializing session " + theSession.getClass().getName() + ": " + ex));
            try {
                theSession.endConnection();
            }
            catch (EPPCommandException ePPCommandException) {
                // empty catch block
            }
            throw ex;
        }
        log.debug((Object)"makeObject(): exit");
        return theSession;
    }

    public void passivateObject(Object aSession) throws Exception {
    }

    public boolean validateObject(Object aSession) {
        boolean isValid;
        log.debug((Object)("validateObject(): enter, session id = " + aSession));
        EPPSession theSession = (EPPSession)aSession;
        EPPPooledSession thePooledSession = (EPPPooledSession)aSession;
        long currentTime = System.currentTimeMillis();
        try {
            if (currentTime - thePooledSession.getCreatedTime() > this.getAbsoluteTimeout()) {
                log.debug((Object)("validateObject(): session id = " + aSession + " is past absolute timeout"));
                isValid = false;
            } else if (System.currentTimeMillis() - thePooledSession.getLastTouched() > this.getIdleTimeout()) {
                log.debug((Object)("validateObject(): session id = " + aSession + " is past idle timeout, sending hello"));
                theSession.hello();
                thePooledSession.touch();
                isValid = true;
            } else {
                log.debug((Object)("validateObject(): session id = " + aSession + " is valid"));
                isValid = true;
            }
        }
        catch (Exception ex) {
            log.debug((Object)("validateObject(): session id = " + aSession + " caused Exception: " + ex));
            isValid = false;
        }
        log.debug((Object)("validateObject(): exit, isValid = " + isValid));
        return isValid;
    }

    protected EPPSession makeSession() throws Exception {
        log.debug((Object)"makeSession(): enter");
        if (this.serverName == null || this.serverPort == null) {
            throw new EPPSessionPoolException("makeSession(): serverName or serverPort is null");
        }
        if (this.clientHost == null) {
            return new EPPPooledGenericSession(this.serverName, (int)this.serverPort, this.sslContext);
        }
        return new EPPPooledGenericSession(this.serverName, this.serverPort, this.clientHost, this.sslContext);
    }
}

