/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.whowas.EPPWhoWasHistory;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoResp;
import com.verisign.epp.codec.whowas.EPPWhoWasRecord;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.EPPWhoWas;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPWhoWasTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String TRANSACTION_ID = "ABC-12345";
    private static final String NON_EXISTING_TEST_NAME = "non-existing.com";
    private static final String NON_EXISTING_TEST_ROID = "non-existing";
    private static final Logger cat = Logger.getLogger((String)EPPWhoWasTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static String configFileName = "epp.config";
    private int iteration = 0;
    private EPPSession session = null;
    private EPPWhoWas whowas = null;

    public EPPWhoWasTst(String aName) {
        super(aName);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPWhoWasTst Thread " + i, EPPWhoWasTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPWhoWasTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public static Test suite() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        TestSuite suite = new TestSuite(EPPWhoWasTst.class);
        try {
            System.out.println(configFileName);
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public void testWhoWasInfo() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        try {
            this.iteration = 0;
            while (numIterations == 0 || this.iteration < numIterations) {
                this.printStart("EPPWhoWasTst testWhoWasInfo");
                this.whowasInfoByName();
                this.whowasInfoByRoid();
                this.printEnd("EPPWhoWasTst testWhoWasInfo");
                ++this.iteration;
            }
        }
        catch (EPPCommandException eX) {
            this.handleException(eX);
        }
    }

    public void testNullNameAndRoidWhoWasInfo() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("EPPWhoWasTst testNegativeWhoWasInfo");
            try {
                this.sendInfoAndAssertResponse(null, null, null);
                EPPWhoWasTst.fail((String)"EPPCommandException should have been received");
            }
            catch (EPPCommandException eX) {
                EPPWhoWasTst.assertEquals(EPPCommandException.class, eX.getClass());
            }
            this.printEnd("EPPWhoWasTst testNegativeWhoWasInfo");
            ++this.iteration;
        }
    }

    public void testNonExistingEntityWhoWasInfo() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            EPPResponse response;
            this.printStart("EPPWhoWasTst testNonExistingEntityWhoWasInfo");
            try {
                this.sendInfoAndAssertResponse("domain", NON_EXISTING_TEST_NAME, null);
                EPPWhoWasTst.fail((String)"EPPCommandException should have been received");
            }
            catch (EPPCommandException eX) {
                response = eX.getResponse();
                EPPWhoWasTst.assertEquals((String)"Response should be 2303", (int)2303, (int)response.getResult().getCode());
                System.out.println("The WhoWas Response for Non Existing object is [ " + response + "]");
            }
            try {
                this.sendInfoAndAssertResponse("domain", null, NON_EXISTING_TEST_ROID);
                EPPWhoWasTst.fail((String)"EPPCommandException should have been received");
            }
            catch (EPPCommandException eX) {
                response = eX.getResponse();
                EPPWhoWasTst.assertEquals((String)"Response should be 2303", (int)2303, (int)response.getResult().getCode());
                System.out.println("The WhoWas Response for Non Existing object is [ " + response + "]");
            }
            this.printEnd("EPPWhoWasTst testNonExistingEntityWhoWasInfo");
            ++this.iteration;
        }
    }

    public void whowasInfoByName() throws EPPCommandException {
        this.printStart("whowasInfoByName");
        this.sendInfoAndAssertResponse("domain", "create-operation-history.com", null);
        this.sendInfoAndAssertResponse("domain", "all-operation-history.com", null);
        this.sendInfoAndAssertResponse(null, "create-operation-history.com", null);
        this.sendInfoAndAssertResponse("domain", "default-history.com", null);
        this.printEnd("whowasInfoByName");
    }

    public void whowasInfoByRoid() throws EPPCommandException {
        this.printStart("whowasInfoByRoid");
        this.sendInfoAndAssertResponse("domain", null, "create-rep");
        this.sendInfoAndAssertResponse("domain", null, "all-rep");
        this.sendInfoAndAssertResponse(null, null, "create-rep");
        this.sendInfoAndAssertResponse("domain", null, "default-history");
        this.printEnd("whowasInfoByRoid");
    }

    private void sendInfoAndAssertResponse(String aType, String aName, String aRoid) throws EPPCommandException {
        this.whowas.setTransId(TRANSACTION_ID);
        if (aType != null) {
            this.whowas.setType(aType);
        }
        this.whowas.setName(aName);
        this.whowas.setRoid(aRoid);
        System.out.println("\n\nSending InfoCmd to get history by " + (aName != null ? "name: " + aName : "") + (aRoid != null ? "roid: " + aRoid : ""));
        EPPWhoWasInfoResp response = this.whowas.sendInfo();
        System.out.println("The WhoWas Response is [ " + response + "]");
        for (int i = 0; i < response.getResults().size(); ++i) {
            EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
            System.out.println("Result Code    : " + myResult.getCode());
            System.out.println("Result Message : " + myResult.getMessage());
            System.out.println("Result Lang    : " + myResult.getLang());
            if (myResult.isSuccess()) {
                System.out.println("Command Passed ");
            } else {
                System.out.println("Command Failed ");
            }
            if (myResult.getValues() == null) continue;
            for (int k = 0; k < myResult.getValues().size(); ++k) {
                System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
            }
        }
        if (response.getResult().isSuccess()) {
            if (aType != null) {
                EPPWhoWasTst.assertEquals((String)"Type should match", (String)aType, (String)response.getWhowasType());
            } else {
                EPPWhoWasTst.assertEquals((String)"If type is NOT set, then type should be domain by default", (String)"domain", (String)response.getWhowasType());
            }
            EPPWhoWasTst.assertEquals((String)"Name should match", (String)aName, (String)response.getName());
            EPPWhoWasTst.assertEquals((String)"Roid should match", (String)aRoid, (String)response.getRoid());
            this.assertWhoWasHistory(response.getHistory());
        }
    }

    private void assertWhoWasHistory(EPPWhoWasHistory aEPPWhoWasHistory) {
        EPPWhoWasTst.assertNotNull((String)"History should be not null", (Object)aEPPWhoWasHistory);
        List historyRecords = aEPPWhoWasHistory.getRecords();
        EPPWhoWasTst.assertTrue((String)"History should have more than 0 records", (historyRecords.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < historyRecords.size(); ++i) {
            EPPWhoWasRecord historyRecord = (EPPWhoWasRecord)historyRecords.get(i);
            EPPWhoWasTst.assertNotNull((String)"Name shoudn't be null", (Object)historyRecord.getName());
            EPPWhoWasTst.assertNotNull((String)"Roid shoudn't be null", (Object)historyRecord.getRoid());
            EPPWhoWasTst.assertNotNull((String)"Operation shoudn't be null", (Object)historyRecord.getOperation());
            EPPWhoWasTst.assertNotNull((String)"Transaction Date shoudn't be null", (Object)historyRecord.getTransactionDate());
            EPPWhoWasTst.assertNotNull((String)"Client ID shoudn't be null", (Object)historyRecord.getClientID());
            EPPWhoWasTst.assertNotNull((String)"Client Name shoudn't be null", (Object)historyRecord.getClientName());
            this.printStart("printing attributes of record [" + i + "]");
            System.out.println("\nRecord Name[" + i + "]:" + historyRecord.getName());
            System.out.println("Record Roid[" + i + "]:" + historyRecord.getRoid());
            System.out.println("Record New Name[" + i + "]:" + historyRecord.getNewName());
            System.out.println("Record Operation[" + i + "]:" + historyRecord.getOperation());
            System.out.println("Record Transaction Date[" + i + "]:" + historyRecord.getTransactionDate());
            System.out.println("Record Client ID[" + i + "]:" + historyRecord.getClientID());
            System.out.println("Record Client Name[" + i + "]:" + historyRecord.getClientName());
            this.printEnd("printing attributes of record [" + i + "]");
        }
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.whowas = new EPPWhoWas(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }
}

