/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionAddress;
import com.verisign.epp.codec.suggestion.EPPSuggestionCoordinates;
import com.verisign.epp.codec.suggestion.EPPSuggestionFilter;
import com.verisign.epp.codec.suggestion.EPPSuggestionGeo;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoCmd;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoResp;
import com.verisign.epp.codec.suggestion.util.RandomHelper;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.EPPSuggestion;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSuggestionTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static final Logger cat = Logger.getLogger((String)EPPSuggestionTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static String configFileName = "epp.config";
    private int iteration = 0;
    private EPPSession session = null;
    private EPPSuggestion suggestion = null;

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPSuggestionTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSuggestionTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public static Test suite() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        TestSuite suite = new TestSuite(EPPSuggestionTst.class);
        try {
            System.out.println(configFileName);
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public EPPSuggestionTst(String name) {
        super(name);
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public void suggestionInfo() {
        this.printStart("suggestionInfo");
        try {
            EPPSuggestionInfoCmd theRandomCmd = RandomHelper.getCommand();
            theRandomCmd.setKey("RANDOMIZE");
            theRandomCmd.setLanguage("POR");
            theRandomCmd.setSubId("AX7SHJ12");
            this.suggestion.setCommand(theRandomCmd);
            System.out.println("\nsuggestionInfoCmd: " + EPPUtil.toString(theRandomCmd));
            EPPSuggestionInfoResp response = this.suggestion.sendInfo();
            System.out.println("\nsuggestionInfoRsp: " + EPPUtil.toString(response));
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPDecodeException e) {
            System.out.println("Internal error: dummy command is invalid");
        }
        this.printEnd("suggestionInfo");
    }

    public void suggestionInfoTableView() {
        this.printStart("suggestionInfoTableView");
        try {
            EPPSuggestionInfoCmd theRandomCmd = RandomHelper.getCommand();
            theRandomCmd.setKey("SOCCERTEAM.COM");
            theRandomCmd.setLanguage("ESP");
            theRandomCmd.unsetFilterId();
            theRandomCmd.setSubId("AX7SHJ12");
            EPPSuggestionFilter theFilter = new EPPSuggestionFilter();
            theFilter.setTableView();
            theRandomCmd.setFilter(theFilter);
            this.suggestion.setCommand(theRandomCmd);
            System.out.println("\nsuggestionInfoCmd: " + EPPUtil.toString(theRandomCmd));
            EPPSuggestionInfoResp response = this.suggestion.sendInfo();
            System.out.println("\nsuggestionInfoRsp: " + EPPUtil.toString(response));
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPDecodeException e) {
            System.out.println("Internal error: dummy command is invalid");
        }
        this.printEnd("suggestionInfoTableView");
    }

    public void suggestionInfoTableViewFrench() {
        this.printStart("suggestionInfoTableViewFrench");
        try {
            EPPSuggestionInfoCmd theRandomCmd = RandomHelper.getCommand();
            theRandomCmd.setKey("SOCCERTEAM.COM");
            theRandomCmd.setLanguage("FRE");
            theRandomCmd.unsetFilterId();
            theRandomCmd.setSubId("AX7SHJ12");
            EPPSuggestionFilter theFilter = new EPPSuggestionFilter();
            theFilter.setTableView();
            theRandomCmd.setFilter(theFilter);
            this.suggestion.setCommand(theRandomCmd);
            System.out.println("\nsuggestionInfoCmd: " + EPPUtil.toString(theRandomCmd));
            EPPSuggestionInfoResp response = this.suggestion.sendInfo();
            System.out.println("\nsuggestionInfoRsp: " + EPPUtil.toString(response));
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPDecodeException e) {
            System.out.println("Internal error: dummy command is invalid");
        }
        this.printEnd("suggestionInfoTableViewFrench");
    }

    public void suggestionInfoGridView() {
        this.printStart("suggestionInfoGridView");
        try {
            EPPSuggestionInfoCmd theRandomCmd = RandomHelper.getCommand();
            theRandomCmd.setKey("SOCCERTEAM");
            theRandomCmd.setLanguage("GER");
            theRandomCmd.unsetFilterId();
            theRandomCmd.setSubId("AX7SHJ12");
            EPPSuggestionFilter theFilter = new EPPSuggestionFilter();
            theFilter.setGridView();
            theRandomCmd.setFilter(theFilter);
            this.suggestion.setCommand(theRandomCmd);
            System.out.println("\nsuggestionInfoCmd: " + EPPUtil.toString(theRandomCmd));
            EPPSuggestionInfoResp response = this.suggestion.sendInfo();
            System.out.println("\nsuggestionInfoRsp: " + EPPUtil.toString(response));
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPDecodeException e) {
            System.out.println("Internal error: dummy command is invalid");
        }
        this.printEnd("suggestionInfoGridView");
    }

    public void suggestionInfoGeoCoordinates() {
        this.printStart("suggestionInfoGridView");
        try {
            EPPSuggestionInfoCmd theRandomCmd = RandomHelper.getCommand();
            theRandomCmd.setKey("SOCCERTEAM");
            theRandomCmd.setLanguage("GER");
            theRandomCmd.unsetFilterId();
            theRandomCmd.setSubId("AX7SHJ12");
            EPPSuggestionFilter theFilter = new EPPSuggestionFilter();
            EPPSuggestionGeo geo = new EPPSuggestionGeo();
            geo.setCoordinates(new EPPSuggestionCoordinates(34.1234, -5.4321));
            theFilter.setGeo(geo);
            theFilter.setGridView();
            theRandomCmd.setFilter(theFilter);
            this.suggestion.setCommand(theRandomCmd);
            System.out.println("\nsuggestionInfoCmd: " + EPPUtil.toString(theRandomCmd));
            EPPSuggestionInfoResp response = this.suggestion.sendInfo();
            System.out.println("\nsuggestionInfoRsp: " + EPPUtil.toString(response));
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPDecodeException e) {
            System.out.println("Internal error: dummy command is invalid");
        }
        this.printEnd("suggestionInfoGridView");
    }

    public void suggestionInfoGeoLocation() {
        this.printStart("suggestionInfoGridView");
        try {
            EPPSuggestionInfoCmd theRandomCmd = RandomHelper.getCommand();
            theRandomCmd.setKey("SOCCERTEAM");
            theRandomCmd.setLanguage("GER");
            theRandomCmd.unsetFilterId();
            theRandomCmd.setSubId("AX7SHJ12");
            EPPSuggestionFilter theFilter = new EPPSuggestionFilter();
            EPPSuggestionGeo geo = new EPPSuggestionGeo();
            geo.setAddr(new EPPSuggestionAddress("127.0.0.1"));
            theFilter.setGeo(geo);
            theFilter.setGridView();
            theRandomCmd.setFilter(theFilter);
            this.suggestion.setCommand(theRandomCmd);
            System.out.println("\nsuggestionInfoCmd: " + EPPUtil.toString(theRandomCmd));
            EPPSuggestionInfoResp response = this.suggestion.sendInfo();
            System.out.println("\nsuggestionInfoRsp: " + EPPUtil.toString(response));
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPDecodeException e) {
            System.out.println("Internal error: dummy command is invalid");
        }
        this.printEnd("suggestionInfoGridView");
    }

    public void suggestionInfoGeoIpaddress() {
        this.printStart("suggestionInfoGeoIpaddress");
        try {
            EPPSuggestionInfoCmd theRandomCmd = RandomHelper.getCommand();
            theRandomCmd.setKey("SOCCERTEAM");
            theRandomCmd.setLanguage("GER");
            theRandomCmd.unsetFilterId();
            theRandomCmd.setSubId("AX7SHJ12");
            EPPSuggestionFilter theFilter = new EPPSuggestionFilter();
            EPPSuggestionGeo geo = new EPPSuggestionGeo();
            EPPSuggestionAddress addr = new EPPSuggestionAddress("127.0.0.1");
            geo.setAddr(addr);
            theFilter.setGeo(geo);
            theFilter.setGridView();
            theRandomCmd.setFilter(theFilter);
            this.suggestion.setCommand(theRandomCmd);
            System.out.println("\nsuggestionInfoCmd: " + EPPUtil.toString(theRandomCmd));
            EPPSuggestionInfoResp response = this.suggestion.sendInfo();
            System.out.println("\nsuggestionInfoRsp: " + EPPUtil.toString(response));
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPDecodeException e) {
            System.out.println("Internal error: dummy command is invalid");
        }
        this.printEnd("suggestionInfoGeoIpaddress");
    }

    public void testSuggestion() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.suggestionInfoTableView();
            this.suggestionInfoTableViewFrench();
            this.suggestionInfoGridView();
            this.suggestionInfoGeoCoordinates();
            this.suggestionInfoGeoLocation();
            this.suggestionInfoGeoIpaddress();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.suggestion = new EPPSuggestion(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }
}

