/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.whowas;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoCmd;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoResp;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPWhoWasMapFactory
extends EPPMapFactory {
    public static final String NS = "http://www.verisign.com/epp/whowas-1.0";
    public static final String NS_PREFIX = "whowas";
    private static final String XSD_NAME = "whowas-1.0.xsd";
    public static final String NS_SCHEMA = "http://www.verisign.com/epp/whowas-1.0 whowas-1.0.xsd";
    private EPPService service = new EPPService("whowas", "http://www.verisign.com/epp/whowas-1.0", "http://www.verisign.com/epp/whowas-1.0 whowas-1.0.xsd");

    public EPPWhoWasMapFactory() {
        this.service.setServiceType(0);
    }

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("whowas:info"))) {
            return new EPPWhoWasInfoCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("whowas:infData"))) {
            return new EPPWhoWasInfoResp();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        HashSet<String> theSchemas = new HashSet<String>();
        theSchemas.add(XSD_NAME);
        return theSchemas;
    }
}

