/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionFilter;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.UnsignedLong;
import com.verisign.epp.util.EqualityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSuggestionInfoCmd
extends EPPInfoCmd {
    private static final long serialVersionUID = -5908410757699049707L;
    private static final String ELM_FILTER = "suggestion:filter";
    private static final String ELM_FILTERID = "suggestion:filterid";
    static final String ELM_NAME = "suggestion:info";
    private EPPSuggestionFilter filter = null;
    private UnsignedLong filterId = new UnsignedLong();
    private String key = null;
    private String language = "ENG";
    private String subId = null;

    public EPPSuggestionInfoCmd() {
        this(null);
    }

    public EPPSuggestionInfoCmd(String aTransId) {
        super(aTransId);
    }

    public EPPSuggestionFilter getFilter() {
        return this.filter;
    }

    public UnsignedLong getFilterId() {
        return this.filterId;
    }

    public String getKey() {
        return this.key;
    }

    public String getSubId() {
        return this.subId;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign-grs.com/epp/suggestion-1.1";
    }

    public void setFilter(EPPSuggestionFilter aFilter) {
        this.filter = aFilter;
    }

    public void setFilterId(long aFilterId) throws InvalidValueException {
        this.filterId.set(aFilterId);
    }

    public void setFilterId(UnsignedLong aFilterId) {
        if (this.filterId == null) {
            this.filterId.unset();
        } else {
            this.filterId = aFilterId;
        }
    }

    public void unsetFilterId() {
        this.filterId.unset();
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public void setSubId(String aSubId) {
        this.subId = aSubId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage == null ? "ENG" : aLanguage.toUpperCase();
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        String decodedSubId;
        String decodedLanguage;
        this.key = EPPUtil.decodeString(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:key");
        if (this.key == null) {
            ExceptionUtil.missingDuringDecode("key");
        }
        if ((decodedLanguage = EPPUtil.decodeString(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:language")) == null) {
            decodedLanguage = "ENG";
        }
        this.language = decodedLanguage.toUpperCase();
        this.filter = (EPPSuggestionFilter)EPPUtil.decodeComp(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", ELM_FILTER, EPPSuggestionFilter.class);
        if (this.filter == null) {
            this.filterId.set(EPPUtil.decodeString(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", ELM_FILTERID));
        }
        this.subId = decodedSubId = EPPUtil.decodeString(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:subID");
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        root.setAttribute("xmlns:suggestion", "http://www.verisign-grs.com/epp/suggestion-1.1");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign-grs.com/epp/suggestion-1.1 suggestion-1.1.xsd");
        if (this.key == null) {
            ExceptionUtil.missingDuringEncode("key");
        }
        EPPUtil.encodeString(aDocument, root, this.key, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:key");
        if (this.language != null && !this.language.equals("ENG")) {
            EPPUtil.encodeString(aDocument, root, this.language, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:language");
        }
        if (this.filter != null) {
            EPPUtil.encodeComp(aDocument, root, this.filter);
        }
        if (this.filterId.isSet()) {
            EPPUtil.encodeString(aDocument, root, this.filterId + "", "http://www.verisign-grs.com/epp/suggestion-1.1", ELM_FILTERID);
        }
        if (this.subId != null) {
            EPPUtil.encodeString(aDocument, root, this.subId, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:subID");
        }
        return root;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionInfoCmd)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            if (!super.equals(o)) {
                return false;
            }
            EPPSuggestionInfoCmd other = (EPPSuggestionInfoCmd)o;
            if (!EqualityUtil.equals(this.key, other.key)) {
                return false;
            }
            if (!this.filterId.equals(other.filterId)) {
                return false;
            }
            if (!EqualityUtil.equals(this.filter, other.filter)) {
                return false;
            }
            if (!EqualityUtil.equals(this.language, other.language)) {
                return false;
            }
            return EqualityUtil.equals(this.subId, other.subId);
        }
        return false;
    }
}

