/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.resellerext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPResellerExtInfData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPResellerExtInfData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "resellerext:infData";
    private static final String ELM_RESELLER_ID = "id";
    private static final String ELM_RESELLER_NAME = "name";
    private String resellerId;
    private String resellerName;

    public EPPResellerExtInfData() {
    }

    public EPPResellerExtInfData(String aResellerId) {
        this.setResellerId(aResellerId);
    }

    public EPPResellerExtInfData(String aResellerId, String aResellerName) {
        this.setResellerId(aResellerId);
        this.setResellerName(aResellerName);
    }

    public String getResellerId() {
        return this.resellerId;
    }

    public void setResellerId(String aResellerId) {
        this.resellerId = aResellerId;
    }

    public boolean hasResellerName() {
        return this.resellerName != null;
    }

    public String getResellerName() {
        return this.resellerName;
    }

    public void setResellerName(String aResellerName) {
        this.resellerName = aResellerName;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.resellerId == null) {
            throw new EPPEncodeException("Undefined resellerId in EPPResellerExtInfoResp");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:resellerext-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.resellerId, "urn:ietf:params:xml:ns:resellerext-1.0", "resellerext:id");
        EPPUtil.encodeString(aDocument, root, this.resellerName, "urn:ietf:params:xml:ns:resellerext-1.0", "resellerext:name");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.resellerId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:resellerext-1.0", ELM_RESELLER_ID);
        this.resellerName = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:resellerext-1.0", ELM_RESELLER_NAME);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerExtInfData clone = (EPPResellerExtInfData)super.clone();
        return clone;
    }

    public String getType() {
        return ELM_NAME;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:resellerext-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerExtInfData)) {
            return false;
        }
        EPPResellerExtInfData other = (EPPResellerExtInfData)aObject;
        if (!EqualityUtil.equals(this.resellerId, other.resellerId)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): resellerId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.resellerName, other.resellerName)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): resellerName not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

