/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryUpdateResp
extends EPPResponse {
    private static final long serialVersionUID = -4667715413601551579L;
    static final String ELM_NAME = "registry:updData";
    private static final String ELM_REGISTRY_NAME = "registry:name";
    private static final String ELM_CREATION_DATE = "registry:crDate";
    private static final String ELM_UPDATE_DATE = "registry:upDate";
    private static final String ELM_ROID = "registry:roid";
    private String name = null;
    private Date createDate = null;
    private Date updateDate = null;

    public EPPRegistryUpdateResp() {
    }

    public EPPRegistryUpdateResp(EPPTransId aTransId, String name) {
        super(aTransId);
        this.name = name;
    }

    public EPPRegistryUpdateResp(EPPTransId aTransId, String name, Date createDate) {
        this(aTransId, name);
        this.createDate = createDate;
    }

    public EPPRegistryUpdateResp(EPPTransId aTransId, String name, Date createDate, Date updateDate) {
        this(aTransId, name, createDate);
        this.updateDate = updateDate;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryUpdateResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPRegistryUpdateResp theComp = (EPPRegistryUpdateResp)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.createDate != null ? this.createDate.equals(theComp.createDate) : theComp.createDate == null)) {
            return false;
        }
        return this.updateDate != null ? this.updateDate.equals(theComp.updateDate) : theComp.updateDate == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryUpdateResp clone = (EPPRegistryUpdateResp)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.createDate == null) {
            throw new EPPCodecException("required attribute createDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryUpdateResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute("xmlns:registry", "http://www.verisign.com/epp/registry-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign.com/epp/registry-1.0 registry-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createDate, "http://www.verisign.com/epp/registry-1.0", ELM_CREATION_DATE);
        if (this.updateDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.updateDate, "http://www.verisign.com/epp/registry-1.0", ELM_UPDATE_DATE);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        this.createDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CREATION_DATE);
        this.updateDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_UPDATE_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRegistryUpdateResp.decode: " + e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}

