/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryKey;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDS
extends EPPRegistryKey {
    private static final long serialVersionUID = -1180818480629088110L;
    public static final String ELM_NAME = "registry:dsDataInterface";
    public static final String ELM_DIGEST = "registry:digestType";
    private List digestTypes = new ArrayList();

    public EPPRegistryDS() {
    }

    public EPPRegistryDS(Integer min, Integer max, List algorithms, List digestTypes) {
        super(min, max, algorithms);
        this.digestTypes = digestTypes;
    }

    public EPPRegistryDS(int min, int max, List algorithms, List digestTypes) {
        this(new Integer(min), new Integer(max), algorithms, digestTypes);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = super.encode(aDocument);
        if (this.digestTypes != null && this.digestTypes.size() > 0) {
            EPPUtil.encodeList(aDocument, root, this.digestTypes, "http://www.verisign.com/epp/registry-1.0", ELM_DIGEST);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.digestTypes = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_DIGEST);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDS clone = (EPPRegistryDS)super.clone();
        if (this.digestTypes != null) {
            clone.digestTypes = (List)((ArrayList)this.digestTypes).clone();
        }
        return clone;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryDS)) {
            return false;
        }
        EPPRegistryDS theComp = (EPPRegistryDS)aObject;
        return this.digestTypes != null ? EPPUtil.equalLists(this.digestTypes, theComp.digestTypes) : theComp.digestTypes == null;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public List getDigestTypes() {
        return this.digestTypes;
    }

    public void setDigestTypes(List digestTypes) {
        this.digestTypes = digestTypes;
    }

    public void addDigestType(String digestType) {
        if (this.digestTypes == null) {
            this.digestTypes = new ArrayList();
        }
        this.digestTypes.add(digestType);
    }

    @Override
    public String getRootName() {
        return ELM_NAME;
    }
}

