/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPNameWatchRptTo
implements EPPCodecComponent {
    public static final String RPTTO_FREQ_DAILY = "daily";
    public static final String RPTTO_FREQ_WEEKLY = "weekly";
    public static final String RPTTO_FREQ_MONTHLY = "monthly";
    static final String ELM_NAME = "nameWatch:rptTo";
    private static final String ELM_RPTTO = "nameWatch:rptTo";
    private static final String ELM_RPTTO_FREQ = "freq";
    private String rptTo = null;
    private String freqType = "daily";

    public EPPNameWatchRptTo() {
    }

    public EPPNameWatchRptTo(String aRptTo) {
        this.rptTo = aRptTo;
        this.freqType = RPTTO_FREQ_DAILY;
    }

    public EPPNameWatchRptTo(String aFreqType, String aRptTo) {
        this.freqType = aFreqType;
        if (this.freqType == null || !this.freqType.equals(RPTTO_FREQ_DAILY) && !this.freqType.equals(RPTTO_FREQ_WEEKLY) && !this.freqType.equals(RPTTO_FREQ_MONTHLY)) {
            this.freqType = RPTTO_FREQ_DAILY;
        }
        this.rptTo = aRptTo;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameWatchRptTo clone = null;
        clone = (EPPNameWatchRptTo)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String tempVal = null;
        tempVal = aElement.getFirstChild().getNodeValue();
        this.freqType = aElement.getAttribute(ELM_RPTTO_FREQ);
        if (tempVal == null) {
            this.rptTo = null;
            throw new EPPDecodeException("EPPNameWatchRptTo: rptTo should not be null");
        }
        this.rptTo = tempVal;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", "nameWatch:rptTo");
        if (this.freqType == null) {
            throw new EPPEncodeException("EPPNameWatchRptTo: RptTo freq should not be null");
        }
        root.setAttribute(ELM_RPTTO_FREQ, this.freqType);
        Text currVal = aDocument.createTextNode(this.rptTo);
        root.appendChild(currVal);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameWatchRptTo)) {
            return false;
        }
        EPPNameWatchRptTo theComp = (EPPNameWatchRptTo)aObject;
        if (!this.rptTo.equals(theComp.rptTo)) {
            return false;
        }
        return this.freqType != null ? this.freqType.equals(theComp.freqType) : theComp.freqType == null;
    }

    public String getRptTo() {
        return this.rptTo;
    }

    public String getFreqType() {
        return this.freqType;
    }

    public boolean isRptToUnspec() {
        return this.rptTo == null;
    }

    public void setRptTo(String newRptTo) throws EPPCodecException {
        StringTokenizer st;
        int i = 0;
        if (this.rptTo != null && (i = (st = new StringTokenizer(newRptTo, "@")).countTokens()) < 2) {
            throw new EPPCodecException("invalid reply to format");
        }
        this.rptTo = newRptTo;
    }

    public void setFreqType(String newFreqType) {
        this.freqType = newFreqType;
        if (!(this.freqType.equals(RPTTO_FREQ_DAILY) || this.freqType.equals(RPTTO_FREQ_WEEKLY) || this.freqType.equals(RPTTO_FREQ_MONTHLY))) {
            this.freqType = RPTTO_FREQ_DAILY;
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

