/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.management;

import com.codestudio.management.ConfigParser;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;

public class PoolManConfiguration {
    private String configFile;
    private ConfigParser handler;
    private ArrayList datasources;
    private ArrayList genericObjects;
    private boolean useJMX = false;
    static /* synthetic */ Class class$com$codestudio$management$PoolManConfiguration;

    public PoolManConfiguration(String string) {
        this.configFile = string;
        this.datasources = new ArrayList();
        this.genericObjects = new ArrayList();
    }

    public boolean isUsingJMX() {
        return this.handler.isManagementJMX();
    }

    public void loadConfiguration() throws Exception {
        try {
            this.parseXML();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("\n** ERROR: Unable to find XML file " + this.configFile + ": " + nullPointerException);
        }
        catch (Exception exception) {
            System.out.println("\n** ERROR: Unable to parse XML file " + this.configFile + ": " + exception);
        }
    }

    public ArrayList getDataSources() {
        return this.datasources;
    }

    public ArrayList getGenericPools() {
        return this.genericObjects;
    }

    public Properties getAdminProperties() {
        return this.handler.getAdminProps();
    }

    private void parseXML() throws Exception {
        this.handler = new ConfigParser();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        URL uRL = (class$com$codestudio$management$PoolManConfiguration == null ? (class$com$codestudio$management$PoolManConfiguration = PoolManConfiguration.class$("com.codestudio.management.PoolManConfiguration")) : class$com$codestudio$management$PoolManConfiguration).getClassLoader().getResource(this.configFile);
        if (uRL == null) {
            (class$com$codestudio$management$PoolManConfiguration == null ? (class$com$codestudio$management$PoolManConfiguration = PoolManConfiguration.class$("com.codestudio.management.PoolManConfiguration")) : class$com$codestudio$management$PoolManConfiguration).getClassLoader().getResource("/" + this.configFile);
        }
        if (uRL == null) {
            Thread.currentThread().getContextClassLoader().getResource(this.configFile);
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(this.configFile);
        }
        sAXParser.parse(uRL.toString(), (HandlerBase)this.handler);
        this.datasources = this.handler.getDataSourceProperties();
        this.genericObjects = this.handler.getGenericProperties();
    }

    private ArrayList parseProperties(String string) throws Exception {
        Serializable serializable;
        Object object;
        Iterator iterator;
        Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>();
        InputStream inputStream = null;
        Properties properties = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            properties = new Properties();
            properties.load(inputStream);
        }
        catch (Exception exception) {
            if (string.equals("poolman.props")) {
                try {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("pool.props");
                    properties = new Properties();
                    properties.load(inputStream);
                }
                catch (Exception exception2) {
                    throw new Exception("Unable to find and read a valid poolman.xml config file. Please ensure that 'poolman.xml' is in a directory that is in your CLASSPATH.\n");
                }
                System.out.println("\nPLEASE NOTE: You should replace the pool.props file with a valid poolman.xml file\n");
            }
            throw new Exception("ERROR: Unable to find and read a valid PoolMan properties file.\nPlease ensure that poolman.xml or at least " + string + " is in a directory that is in your CLASSPATH.\n");
        }
        Properties properties2 = null;
        String string2 = null;
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            iterator = (String)enumeration.nextElement();
            object = iterator;
            if (((String)((Object)iterator)).indexOf("_") != -1) {
                serializable = new StringBuffer(((String)((Object)iterator)).substring(0, ((String)((Object)iterator)).indexOf("_")));
                ((StringBuffer)serializable).append(((String)((Object)iterator)).substring(((String)((Object)iterator)).indexOf("_") + 1, ((String)((Object)iterator)).length()));
                object = ((StringBuffer)serializable).toString();
                if (!((String)object).toLowerCase().equals("dbname") && ((String)object).startsWith("db")) {
                    object = ((String)object).substring(2, ((String)object).length());
                }
            }
            if (((String)object).toLowerCase().startsWith("cacherefresh")) {
                object = "cacherefreshinterval" + ((String)object).substring(12, ((String)object).length());
            }
            try {
                string2 = ((String)((Object)iterator)).substring(((String)((Object)iterator)).indexOf(46) + 1, ((String)((Object)iterator)).length());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new Exception("Unnumbered property in poolman.props: " + iterator);
            }
            properties2 = hashtable.containsKey(string2) ? (Properties)hashtable.get(string2) : new Properties();
            properties2.setProperty(((String)object).substring(0, ((String)object).indexOf(46)), properties.getProperty((String)((Object)iterator)));
            hashtable.put(string2, properties2);
        }
        iterator = new ArrayList();
        object = hashtable.keySet().iterator();
        while (object.hasNext()) {
            serializable = (Properties)hashtable.get(object.next());
            ((ArrayList)((Object)iterator)).add((Properties)serializable);
        }
        return iterator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

