/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.server;

import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPServerCon;
import com.verisign.epp.transport.EPPServerThread;
import com.verisign.epp.transport.ServerEventHandler;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import java.io.IOException;
import java.net.ServerSocket;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPPlainServer
implements EPPServerCon {
    private static Logger cat = Logger.getLogger((String)EPPPlainServer.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private ServerSocket myServerSocket = null;
    private boolean listening = true;
    private ServerEventHandler myHandler = null;
    private int myPortNumber = 0;
    private int myConTimeout = 0;

    public EPPPlainServer() throws EPPConException {
        cat.debug((Object)"EPPPlainServer.EPPPlainServer(): entering Constructor");
        try {
            this.myPortNumber = EPPEnv.getServerPort();
            this.myConTimeout = EPPEnv.getConTimeOut();
        }
        catch (EPPEnvException myException) {
            cat.error((Object)("Connection Failed Due to : " + myException.getMessage()));
            throw new EPPConException("Connection Failed Due to : " + myException.getMessage());
        }
        cat.debug((Object)("EPPPlainServer.EPPPlainServer(): ServerPort = " + this.myPortNumber));
        cat.debug((Object)"EPPPlainServer.EPPPlainServer(): Exiting Constructor");
    }

    @Override
    public void RunServer(ServerEventHandler newHandler) throws EPPConException {
        cat.debug((Object)"EPPPlainServer.RunServer(): Entering Method");
        this.myHandler = newHandler;
        try {
            this.myServerSocket = new ServerSocket(this.myPortNumber);
        }
        catch (IOException myException) {
            cat.error((Object)("IO Exception : " + myException.getMessage()));
            throw new EPPConException("IO Exception : " + myException.getMessage());
        }
        this.loop();
        this.close();
        cat.debug((Object)"EPPPlainServer.RunServer(): Exiting Method");
    }

    public void loop() throws EPPConException {
        cat.debug((Object)"EPPPlainServer.loop(): Entering Method");
        try {
            while (this.listening) {
                EPPServerThread p = new EPPServerThread(this.myServerSocket.accept(), this.myHandler);
                p.start();
            }
        }
        catch (IOException myException) {
            cat.error((Object)"I/O Error occured when wating for connection");
            throw new EPPConException("I/O Error occured when wating for connection");
        }
        catch (SecurityException myException) {
            cat.error((Object)"security Manger exists and its checkListen method doesn't allow accpet operation");
            throw new EPPConException("security Manger exists and its checkListen method doesn't allow accpet operation");
        }
        cat.debug((Object)"EPPPlainServer.loop(): Exiting Method");
    }

    public void close() throws EPPConException {
        cat.debug((Object)"EPPPlainServer.close(): Entering Method");
        try {
            this.myServerSocket.close();
        }
        catch (Exception myException) {
            cat.error((Object)"Close on Server socket Failed");
            throw new EPPConException("Close on Server socket Failed");
        }
        cat.debug((Object)"EPPPlainServer.close(): Exiting Method");
    }
}

