/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.resellerext.EPPResellerExtCreate;
import com.verisign.epp.codec.resellerext.EPPResellerExtInfData;
import com.verisign.epp.codec.resellerext.EPPResellerExtUpdate;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class ResellerExtDomainHandler
extends DomainHandler {
    private static Logger cat = Logger.getLogger((String)ResellerExtDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        SessionData theSessionData = (SessionData)aData;
        if (theSessionData.getLoginCmd().hasExtensionService("urn:ietf:params:xml:ns:resellerext-1.0") && theCommand.getName().equalsIgnoreCase("reseller.example")) {
            EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
            theResponse.addExtension(new EPPResellerExtInfData("myreseller", "example"));
        }
        cat.info((Object)"doDomainInfo: EPPResellerExt added to response");
        System.out.println("doDomainInfo: EPPResellerExt added to response");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPResellerExtCreate.class)) {
            EPPResellerExtCreate theExt = (EPPResellerExtCreate)theCommand.getExtension(EPPResellerExtCreate.class);
            cat.info((Object)("doDomainCreate: reseller identifier = " + theExt.getResellerId()));
            System.out.println("doDomainCreate: reseller identifier = " + theExt.getResellerId());
        } else {
            cat.info((Object)"doDomainCreate: Reseller Extension = null");
            System.out.println("doDomainCreate: Reseller Extension = null");
        }
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPResellerExtUpdate.class)) {
            EPPResellerExtUpdate theExt = (EPPResellerExtUpdate)theCommand.getExtension(EPPResellerExtUpdate.class);
            cat.info((Object)("doDomainUpdate: action = " + (Object)((Object)theExt.getAction()) + ", reseller identifier = " + theExt.getResellerId()));
            System.out.println("doDomainUpdate: action = " + (Object)((Object)theExt.getAction()) + ", reseller identifier = " + theExt.getResellerId());
        } else {
            cat.info((Object)"doDomainUpdate: Reseller Extension = null");
            System.out.println("doDomainUpdate: Reseller Extension = null");
        }
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        return theEventResponse;
    }
}

