/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.reseller.EPPResellerAddress;
import com.verisign.epp.codec.reseller.EPPResellerCheckResp;
import com.verisign.epp.codec.reseller.EPPResellerContact;
import com.verisign.epp.codec.reseller.EPPResellerCreateResp;
import com.verisign.epp.codec.reseller.EPPResellerDisclose;
import com.verisign.epp.codec.reseller.EPPResellerInfoResp;
import com.verisign.epp.codec.reseller.EPPResellerPostalDefinition;
import com.verisign.epp.codec.reseller.State;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPReseller;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPResellerTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPResellerTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPReseller reseller = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPResellerTst(String name) {
        super(name);
    }

    public void testReseller() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.resellerCheck();
            this.resellerInfo();
            this.resellerCreate();
            this.resellerDelete();
            this.resellerUpdate();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void resellerCheck() {
        this.printStart("resellerCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("resellerCheck: Check res1523, re1523, and 1523res reseller identifiers.");
            this.reseller.setTransId("ABC-12345");
            this.reseller.addResellerId("res1523");
            this.reseller.addResellerId("re1523");
            this.reseller.addResellerId("1523res");
            EPPResellerCheckResp response = this.reseller.sendCheck();
            System.out.println("resellerCheck: Reseller Check Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCheck");
    }

    public void resellerInfo() {
        this.printStart("resellerInfo");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("resellerInfo: Info res1523.");
            this.reseller.setTransId("ABC-12345");
            this.reseller.addResellerId("res1523");
            EPPResellerInfoResp response = this.reseller.sendInfo();
            System.out.println("resellerInfo: Reseller Info Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("resellerInfo");
    }

    public void resellerCreate() {
        this.printStart("resellerCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("resellerCreate: Create res1523.");
            this.reseller.setTransId("ABC-12345");
            this.reseller.addResellerId("res1523");
            this.reseller.setState(State.OK);
            this.reseller.setParentId("1523res");
            EPPResellerAddress theAddress = new EPPResellerAddress();
            theAddress.setStreets("124 Example Dr.", "Suite 200");
            theAddress.setCity("Dulles");
            theAddress.setStateProvince("VA");
            theAddress.setPostalCode("20166-6503");
            theAddress.setCountry("US");
            this.reseller.addPostalInfo(new EPPResellerPostalDefinition(EPPResellerPostalDefinition.Type.INT, "Example Reseller Inc.", theAddress));
            this.reseller.setVoice("+1.7035555555");
            this.reseller.setVoiceExt("1234");
            this.reseller.setFax("+1.7035555556");
            this.reseller.setEmail("contact@reseller.example");
            this.reseller.setUrl("http://reseller.example");
            this.reseller.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.ADMINISTRATIVE));
            this.reseller.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.BILLING));
            EPPResellerDisclose disclose = new EPPResellerDisclose(false);
            disclose.setVoice(true);
            disclose.setEmail(true);
            this.reseller.setDisclose(disclose);
            EPPResellerCreateResp response = this.reseller.sendCreate();
            System.out.println("resellerCreate: Reseller Create Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("resellerCreate");
    }

    public void resellerDelete() {
        this.printStart("resellerDelete");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("resellerDelete: Delete res1523.");
            this.reseller.setTransId("ABC-12345");
            this.reseller.addResellerId("res1523");
            EPPResponse response = this.reseller.sendDelete();
            System.out.println("resellerDelete: Reseller Delete Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("resellerDelete");
    }

    public void resellerUpdate() {
        this.printStart("resellerUpdate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("resellerUpdate: Update res1523.");
            this.reseller.setTransId("ABC-12345");
            this.reseller.addResellerId("res1523");
            this.reseller.setState(State.OK);
            this.reseller.setParentId("1523res");
            EPPResellerAddress theAddress = new EPPResellerAddress();
            theAddress.setStreets("124 Example Dr.", "Suite 200");
            theAddress.setCity("Dulles");
            theAddress.setStateProvince("VA");
            theAddress.setPostalCode("20166-6503");
            theAddress.setCountry("US");
            this.reseller.addPostalInfo(new EPPResellerPostalDefinition(EPPResellerPostalDefinition.Type.INT, "Example Reseller Inc.", theAddress));
            this.reseller.setVoice("+1.7035555555");
            this.reseller.setVoiceExt("1234");
            this.reseller.setFax("+1.7035555556");
            this.reseller.setEmail("contact@reseller.example");
            this.reseller.setUrl("http://reseller.example");
            this.reseller.addAddContact(new EPPResellerContact("sh8014", EPPResellerContact.Type.ADMINISTRATIVE));
            this.reseller.addRemContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.BILLING));
            EPPResellerDisclose disclose = new EPPResellerDisclose(false);
            disclose.setVoice(true);
            disclose.setEmail(true);
            this.reseller.setDisclose(disclose);
            EPPResponse response = this.reseller.sendUpdate();
            System.out.println("resellerUpdate: Reseller Update Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("resellerUpdate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.reseller = new EPPReseller(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPResellerTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPResellerTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPResellerTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

