/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.nameWatch.EPPNameWatchAddRemove;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchDeleteCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchPeriod;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRptTo;
import com.verisign.epp.codec.nameWatch.EPPNameWatchStatus;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Date;
import java.util.Vector;

public class EPPNameWatch {
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SERVER_HOLD = "serverHold";
    public static final String STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STATUS_CLIENT_HOLD = "clientHold";
    public static final String STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String STATUS_PENDING_DELETE = "pendingDelete";
    public static final String STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String TRANSFER_APPROVE = "approve";
    public static final String TRANSFER_CANCEL = "cancel";
    public static final String TRANSFER_QUERY = "query";
    public static final String TRANSFER_REJECT = "reject";
    public static final String TRANSFER_REQUEST = "request";
    public static final String FREQ_DAILY = "daily";
    public static final String FREQ_WEEKLY = "weekly";
    public static final String FREQ_MONTHLY = "monthly";
    public static final String PERIOD_MONTH = "m";
    public static final String PERIOD_YEAR = "y";
    private String myName = null;
    private String myRptTo = null;
    private String myFreq = null;
    private String myRoid = null;
    private String myRegistrant = null;
    private EPPSession mySession = null;
    private String myTransId = null;
    private Date myExpirationDate;
    private String myTransferOpCode;
    private int myPeriodLength = 1;
    private String myPeriodUnit = null;
    private String myAuthString;
    private String authRoid;
    private Vector extensions = null;
    private Vector myAddStatuses = null;
    private Vector myRemoveStatuses = null;

    public EPPNameWatch(EPPSession newSession) {
        this.mySession = newSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setRoid(String newRoid) {
        this.myRoid = newRoid;
    }

    public String getRoid() {
        return this.myRoid;
    }

    public void setExpirationDate(Date newExpirationDate) {
        this.myExpirationDate = newExpirationDate;
    }

    public Date getExpirationDate() {
        return this.myExpirationDate;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String newName) {
        this.myName = newName;
    }

    public void setTransferOpCode(String newTransferOpCode) {
        this.myTransferOpCode = newTransferOpCode;
    }

    public void setTransId(String newTransId) {
        this.myTransId = newTransId;
    }

    public void setAuthString(String newAuthString) {
        this.myAuthString = newAuthString;
    }

    public String getAuthString() {
        return this.myAuthString;
    }

    public String getAuthRoid() {
        return this.authRoid;
    }

    public void setAuthRoid(String aAuthRoid) {
        this.authRoid = aAuthRoid;
    }

    public String getRegistrant() {
        return this.myRegistrant;
    }

    public void setRegistrant(String newRegistrant) {
        this.myRegistrant = newRegistrant;
    }

    public String getRptTo() {
        return this.myRptTo;
    }

    public void setRptTo(String aRptTo) {
        this.myRptTo = aRptTo;
    }

    public String getFreq() {
        return this.myFreq;
    }

    public void setFreq(String aFreq) {
        this.myFreq = aFreq;
    }

    public EPPNameWatchCreateResp sendCreate() throws EPPCommandException {
        EPPNameWatchCreateCmd myCommand = new EPPNameWatchCreateCmd(this.myTransId, this.myName, this.myRegistrant, new EPPNameWatchRptTo(this.myFreq, this.myRptTo), new EPPAuthInfo(this.myAuthString));
        Object myPeriod = null;
        if (this.myPeriodLength >= 0) {
            if (this.myPeriodUnit == null) {
                myCommand.setPeriod(new EPPNameWatchPeriod(this.myPeriodLength));
            } else {
                myCommand.setPeriod(new EPPNameWatchPeriod(this.myPeriodUnit, this.myPeriodLength));
            }
        }
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchCreateResp)this.mySession.processDocument(myCommand, EPPNameWatchCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        EPPNameWatchAddRemove addItems = null;
        addItems = this.myAddStatuses != null ? new EPPNameWatchAddRemove(this.myAddStatuses) : new EPPNameWatchAddRemove();
        EPPNameWatchAddRemove removeItems = null;
        removeItems = this.myRemoveStatuses != null ? new EPPNameWatchAddRemove(this.myRemoveStatuses) : new EPPNameWatchAddRemove();
        EPPAuthInfo authInfo = null;
        if (this.myAuthString != null) {
            authInfo = new EPPAuthInfo(this.myAuthString);
        }
        EPPNameWatchRptTo rptTo = null;
        if (this.myRptTo != null && this.myFreq != null) {
            rptTo = new EPPNameWatchRptTo(this.myFreq, this.myRptTo);
        }
        EPPNameWatchAddRemove changeItems = new EPPNameWatchAddRemove(this.myRegistrant, rptTo, authInfo);
        EPPNameWatchUpdateCmd myCommand = new EPPNameWatchUpdateCmd(this.myTransId, this.myRoid, addItems, removeItems, changeItems);
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return this.mySession.processDocument(myCommand, EPPResponse.class);
    }

    public EPPNameWatchTransferResp sendTransfer() throws EPPCommandException {
        EPPNameWatchTransferCmd myCommand = new EPPNameWatchTransferCmd(this.myTransId, this.myTransferOpCode, this.myRoid);
        if (this.myAuthString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.myAuthString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            myCommand.setAuthInfo(theAuthInfo);
        }
        if (this.myTransferOpCode.equals(TRANSFER_REQUEST)) {
            if (this.myAuthString == null) {
                throw new EPPCommandException("Auth Info must be set on a Transfer Request");
            }
            EPPNameWatchPeriod thePeriod = null;
            thePeriod = this.myPeriodLength < 0 ? null : (this.myPeriodUnit == null ? new EPPNameWatchPeriod(this.myPeriodLength) : new EPPNameWatchPeriod(this.myPeriodUnit, this.myPeriodLength));
            myCommand.setPeriod(thePeriod);
        }
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchTransferResp)this.mySession.processDocument(myCommand, EPPNameWatchTransferResp.class);
    }

    public EPPNameWatchRenewResp sendRenew() throws EPPCommandException {
        EPPNameWatchPeriod myPeriod = null;
        myPeriod = this.myPeriodUnit != null ? new EPPNameWatchPeriod(this.myPeriodUnit, this.myPeriodLength) : new EPPNameWatchPeriod(this.myPeriodLength);
        EPPNameWatchRenewCmd myCommand = new EPPNameWatchRenewCmd(this.myTransId, this.myRoid, this.myExpirationDate, myPeriod);
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchRenewResp)this.mySession.processDocument(myCommand, EPPNameWatchRenewResp.class);
    }

    public EPPNameWatchInfoResp sendInfo() throws EPPCommandException {
        EPPNameWatchInfoCmd myCommand = new EPPNameWatchInfoCmd(this.myTransId, this.myRoid);
        if (this.myAuthString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.myAuthString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            myCommand.setAuthInfo(theAuthInfo);
        }
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchInfoResp)this.mySession.processDocument(myCommand, EPPNameWatchInfoResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        EPPNameWatchDeleteCmd myCommand = new EPPNameWatchDeleteCmd(this.myTransId, this.myRoid);
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return this.mySession.processDocument(myCommand, EPPResponse.class);
    }

    private void resetNameWatch() {
        this.myRoid = null;
        this.myTransId = null;
        this.myExpirationDate = null;
        this.myTransferOpCode = null;
        this.myPeriodLength = 1;
        this.myAuthString = null;
        this.authRoid = null;
        this.extensions = null;
        this.myAddStatuses = null;
        this.myRemoveStatuses = null;
        this.myRptTo = null;
        this.myFreq = null;
        this.myRegistrant = null;
    }

    public EPPResponse getResponse() {
        return this.mySession.getResponse();
    }

    public int getPeriodLength() {
        return this.myPeriodLength;
    }

    public void setPeriodLength(int newPeriodLength) {
        this.myPeriodLength = newPeriodLength;
    }

    public String getPeriodUnit() {
        return this.myPeriodUnit;
    }

    public void setPeriodUnit(String newPeriodUnit) {
        this.myPeriodUnit = newPeriodUnit;
    }

    public void addStatus(EPPNameWatchStatus aStatus) {
        if (this.myAddStatuses == null) {
            this.myAddStatuses = new Vector();
        }
        this.myAddStatuses.addElement(aStatus);
    }

    public void removeStatus(EPPNameWatchStatus aStatus) {
        if (this.myRemoveStatuses == null) {
            this.myRemoveStatuses = new Vector();
        }
        this.myRemoveStatuses.addElement(aStatus);
    }
}

