/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v11;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtFactory;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtInfData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtKeyData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate;
import com.verisign.epp.util.TestThread;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPSecDNSExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPSecDNSExtTst(String name) {
        super(name);
    }

    public void testDomainInfoRespWithSecDNSExt() {
        EPPCodecTst.printStart("testDomainInfoRespWithSecDNSExt");
        EPPTransId respTransId = new EPPTransId("54321-CLI", "54321-SER");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.tv", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
        EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
        dsData.setKeyTag(34095);
        dsData.setAlg(5);
        dsData.setDigestType(1);
        dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
        dsData.setKeyData(keyData);
        EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", keyData2);
        EPPSecDNSExtInfData infData = new EPPSecDNSExtInfData();
        infData.setMaxSigLife(604800);
        ArrayList<EPPSecDNSExtDsData> dsDataVec = new ArrayList<EPPSecDNSExtDsData>();
        dsDataVec.add(dsData);
        infData.setDsData(dsDataVec);
        infData.appendDsData(dsData2);
        theResponse.addExtension(infData);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.tv", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        infData = new EPPSecDNSExtInfData();
        infData.setMaxSigLife(604800);
        ArrayList<EPPSecDNSExtKeyData> keyDataList = new ArrayList<EPPSecDNSExtKeyData>();
        keyDataList.add(keyData);
        infData.setKeyData(keyDataList);
        infData.appendKeyData(keyData2);
        theResponse.addExtension(infData);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainInfoRespWithSecDNSExt");
    }

    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345-XYZ", "dsdata-interface.com", new EPPAuthInfo("2fooBAR"));
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        EPPSecDNSExtDsData dsData = null;
        try {
            dsData = keyData.toDsData("dsdata-interface.com", 1);
            dsData.setKeyData(keyData);
        }
        catch (EPPCodecException ex) {
            Assert.fail((String)("Error generating DS data from key data:" + ex));
        }
        EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
        EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", keyData2);
        EPPSecDNSExtCreate create = new EPPSecDNSExtCreate();
        create.setMaxSigLife(604800);
        ArrayList<EPPSecDNSExtDsData> dsDataList = new ArrayList<EPPSecDNSExtDsData>();
        dsDataList.add(dsData);
        create.setDsData(dsDataList);
        create.appendDsData(dsData2);
        theCommand.addExtension(create);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainCreateCmd("ABC-12345-XYZ", "keydata-interface.com", new EPPAuthInfo("2fooBAR"));
        create = new EPPSecDNSExtCreate();
        create.setMaxSigLife(604800);
        ArrayList<EPPSecDNSExtKeyData> keyDataList = new ArrayList<EPPSecDNSExtKeyData>();
        keyDataList.add(keyData);
        create.setKeyData(keyDataList);
        create.appendKeyData(keyData2);
        theCommand.addExtension(create);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    public void testDomainUpdate() {
        EPPCodecTst.printStart("testDomainUpdate");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345");
        EPPSecDNSExtUpdate update = new EPPSecDNSExtUpdate();
        update.appendRemDsData(new EPPSecDNSExtDsData(12345, 3, 1, "38EC35D5B3A34B33C99B"));
        update.appendAddDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
        theCommand.addExtension(update);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345");
        update = new EPPSecDNSExtUpdate();
        update.setMaxSigLife(605900);
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345");
        update = new EPPSecDNSExtUpdate();
        update.appendRemKeyData(new EPPSecDNSExtKeyData(256, 3, 1, "AQPJ////4QQQ"));
        update.appendAddKeyData(new EPPSecDNSExtKeyData(256, 3, 1, "AQPJ////4Q=="));
        update.setMaxSigLife(605900);
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345");
        update = new EPPSecDNSExtUpdate();
        update.appendRemDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345");
        update = new EPPSecDNSExtUpdate();
        update.setUrgent(true);
        update.setRemAllData(true);
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345");
        update = new EPPSecDNSExtUpdate();
        update.setUrgent(true);
        update.setRemAllData(true);
        update.appendAddDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345");
        update = new EPPSecDNSExtUpdate();
        update.appendAddDsData(new EPPSecDNSExtDsData(12346, 3, 1, "38EC35D5B3A34B44C39B"));
        theCommand.addExtension(update);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdate");
    }

    public void testDsDataGeneration() {
        EPPSecDNSExtDsData dsData;
        int digestType;
        String domainName;
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        System.out.println("Source Key Data = [" + keyData + "]");
        try {
            domainName = "example.com";
            digestType = 1;
            dsData = keyData.toDsData(domainName, digestType);
            Assert.assertEquals((int)34095, (int)dsData.getKeyTag());
            Assert.assertEquals((int)5, (int)dsData.getAlg());
            Assert.assertEquals((int)1, (int)dsData.getDigestType());
            Assert.assertEquals((String)"F65DDFF9F2CC042EC2FEE0914320D80FD2315963", (String)dsData.getDigest());
            System.out.println("Generated DS Data for (domain = " + domainName + ", digest type = " + digestType + ") = [" + dsData + "]");
        }
        catch (EPPCodecException ex) {
            Assert.fail((String)("Exception generating DS data for key:" + ex));
        }
        try {
            domainName = "example.com";
            digestType = 2;
            dsData = keyData.toDsData(domainName, digestType);
            Assert.assertEquals((int)34095, (int)dsData.getKeyTag());
            Assert.assertEquals((int)5, (int)dsData.getAlg());
            Assert.assertEquals((int)2, (int)dsData.getDigestType());
            Assert.assertEquals((String)"34B79BF4F0326560AA6D61490C9E65A775C530AD44BC7773162BF2E97BE649D4", (String)dsData.getDigest());
            System.out.println("Generated DS Data for (domain = " + domainName + ", digest type = " + digestType + ") = [" + dsData + "]");
        }
        catch (EPPCodecException ex) {
            Assert.fail((String)("Exception generating DS data for key:" + ex));
        }
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPSecDNSExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory(EPPSecDNSExtFactory.class.getName());
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPSecDNSExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSecDNSExtTst Thread " + i, EPPSecDNSExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSecDNSExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

