/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.mark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMarkAddress;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPMarkContact
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPMarkContact.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ENTITLEMENT_OWNER = "owner";
    public static final String ENTITLEMENT_ASSIGNEE = "assignee";
    public static final String ENTITLEMENT_LICENSEE = "licensee";
    public static final String TYPE_OWNER = "owner";
    public static final String TYPE_AGENT = "agent";
    public static final String TYPE_THIRD_PARTY = "thirdparty";
    public static final String ELM_HOLDER_LOCALNAME = "holder";
    public static final String ELM_CONTACT_LOCALNAME = "contact";
    public static final String ELM_HOLDER_NAME = "mark:holder";
    public static final String ELM_CONTACT_NAME = "mark:contact";
    private static final String ELM_NAME = "name";
    private static final String ELM_ORG = "org";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ATTR_EXT = "x";
    private static final String ATTR_ENTITLEMENT = "entitlement";
    private static final String ATTR_TYPE = "type";
    private String localName = "contact";
    private String entitlement;
    private String type;
    private String name;
    private String org;
    private EPPMarkAddress address;
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;

    public EPPMarkContact() {
    }

    public EPPMarkContact(String aName, String aOrg, EPPMarkAddress aAddress, String aVoice, String aFax, String aEmail) {
        this.name = aName;
        this.org = aOrg;
        this.address = aAddress;
        this.voice = aVoice;
        this.fax = aFax;
        this.email = aEmail;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMarkContact clone = (EPPMarkContact)super.clone();
        if (this.address != null) {
            clone.address = (EPPMarkAddress)this.address.clone();
        }
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Text currVal;
        Element currElm;
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPMark.encode(Document)");
        }
        if (this.address == null) {
            throw new EPPEncodeException("address is required for contact");
        }
        if (this.isContact()) {
            if (this.name == null) {
                throw new EPPEncodeException("name is required for contact");
            }
            if (this.voice == null) {
                throw new EPPEncodeException("voice is required for contact");
            }
            if (this.email == null) {
                throw new EPPEncodeException("email is required for contact");
            }
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", "mark:" + this.localName);
        if (this.isContact()) {
            if (this.type != null) {
                root.setAttribute(ATTR_TYPE, this.type);
            }
        } else if (this.entitlement != null) {
            root.setAttribute(ATTR_ENTITLEMENT, this.entitlement);
        }
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:mark-1.0", "mark:name");
        EPPUtil.encodeString(aDocument, root, this.org, "urn:ietf:params:xml:ns:mark-1.0", "mark:org");
        EPPUtil.encodeComp(aDocument, root, this.address);
        if (this.voice != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", "mark:voice");
            currVal = aDocument.createTextNode(this.voice);
            if (this.voiceExt != null) {
                currElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        if (this.fax != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", "mark:fax");
            currVal = aDocument.createTextNode(this.fax);
            if (this.faxExt != null) {
                currElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:mark-1.0", "mark:email");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element currElm;
        this.localName = aElement.getLocalName();
        if (this.isContact()) {
            this.type = aElement.getAttribute(ATTR_TYPE);
            if (this.type.isEmpty()) {
                this.type = null;
            }
        } else {
            this.entitlement = aElement.getAttribute(ATTR_ENTITLEMENT);
            if (this.entitlement.isEmpty()) {
                this.entitlement = null;
            }
        }
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_NAME);
        this.org = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_ORG);
        this.address = (EPPMarkAddress)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:mark-1.0", "mark:addr", EPPMarkAddress.class);
        this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_VOICE);
        if (this.voice != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_VOICE);
            this.voiceExt = currElm.getAttribute(ATTR_EXT);
            if (this.voiceExt.isEmpty()) {
                this.voiceExt = null;
            }
        } else {
            this.voiceExt = null;
        }
        this.fax = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_FAX);
        if (this.fax != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_FAX);
            this.faxExt = currElm.getAttribute(ATTR_EXT);
            if (this.faxExt.isEmpty()) {
                this.faxExt = null;
            }
        } else {
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_EMAIL);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMarkContact)) {
            cat.error((Object)"EPPMarkContact.equals(): aObject is not an EPPMarkContact");
            return false;
        }
        EPPMarkContact other = (EPPMarkContact)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPMarkContact.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.entitlement, other.entitlement)) {
            cat.error((Object)"EPPMarkContact.equals(): entitlement not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPMarkContact.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.org, other.org)) {
            cat.error((Object)"EPPMarkContact.equals(): org not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.address, other.address)) {
            cat.error((Object)"EPPMarkContact.equals(): address not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error((Object)"EPPMarkContact.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error((Object)"EPPMarkContact.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error((Object)"EPPMarkContact.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error((Object)"EPPMarkContact.equals(): faxExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error((Object)"EPPMarkContact.equals(): email not equal");
            return false;
        }
        return true;
    }

    public boolean isHolderContact() {
        return this.localName.equals(ELM_HOLDER_LOCALNAME);
    }

    public boolean isContact() {
        return this.localName.equals(ELM_CONTACT_LOCALNAME);
    }

    public void setLocalName(String aLocalName) {
        this.localName = aLocalName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public void setEntitlement(String aEntitlement) {
        this.entitlement = aEntitlement;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String aOrg) {
        this.org = aOrg;
    }

    public EPPMarkAddress getAddress() {
        return this.address;
    }

    public void setAddress(EPPMarkAddress aAddress) {
        this.address = aAddress;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

