/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idnmap;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.idnmap.EPPIdnMap;
import com.verisign.epp.util.TestThread;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPIdnMapTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPIdnMapTst(String name) {
        super(name);
    }

    public void testIdnMap() {
        EPPCodecTst.printStart("testIdnMap");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("123456", "xn--espaol-zwa.example.com", new EPPAuthInfo("2fooBAR"));
        theDomainCommand.addExtension(new EPPIdnMap("es", "spa\u00f1ol.example.com"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testIdnMap");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPIdnMapTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.idnmap.EPPIdnMapExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPIdnMapTst Thread " + i, EPPIdnMapTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPIdnMapTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

