/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPContactInfoResp
extends EPPResponse {
    static final String ELM_NAME = "contact:infData";
    private static final String ELM_CLIENT_ID = "contact:clID";
    private static final String ELM_CREATED_BY = "contact:crID";
    private static final String ELM_CREATED_DATE = "contact:crDate";
    private static final String ELM_LAST_UPDATED_BY = "contact:upID";
    private static final String ELM_LAST_UPDATED_DATE = "contact:upDate";
    private static final String ELM_LAST_TRANSFER_DATE = "contact:trDate";
    private static final String ELM_CONTACT_POSTAL_INFO = "contact:postalInfo";
    private static final String ELM_CONTACT_AUTHINFO = "contact:authInfo";
    private static final String ELM_CONTACT_EMAIL = "contact:email";
    private static final String ELM_CONTACT_FAX = "contact:fax";
    private static final String ELM_CONTACT_ID = "contact:id";
    private static final String ELM_CONTACT_STATUSES = "contact:status";
    private static final String ELM_CONTACT_VOICE = "contact:voice";
    private static final String ELM_ROID = "contact:roid";
    private static final String ELM_CONTACT_DISCLOSE = "contact:disclose";
    private static final String ATTR_EXT = "x";
    private String clientId = null;
    private String createdBy = null;
    private Date createdDate = null;
    private String lastUpdatedBy = null;
    private Date lastUpdatedDate = null;
    private Date lastTransferDate = null;
    private Vector postalContacts = new Vector();
    private EPPAuthInfo authInfo = null;
    private EPPContactDisclose disclose = null;
    private String email = null;
    private String fax = null;
    private String faxExt = null;
    private String id = null;
    private Vector statuses = null;
    private String voice = null;
    private String voiceExt = null;
    private String roid = null;

    public EPPContactInfoResp() {
    }

    public EPPContactInfoResp(EPPTransId aTransId, String aRoid, String aId, Vector newStatuses, EPPContactPostalDefinition aPostalInfo, String aEmail, String aClientId, String aCreatedBy, Date aCreatedDate, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.id = aId;
        this.roid = aRoid;
        this.statuses = newStatuses;
        this.postalContacts.add(aPostalInfo);
        this.email = aEmail;
        this.clientId = aClientId;
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String aCreatedBy) {
        this.createdBy = aCreatedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aDate) {
        this.createdDate = aDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String aLastUpdatedBy) {
        this.lastUpdatedBy = aLastUpdatedBy;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    public Date getLastTransferDate() {
        return this.lastTransferDate;
    }

    public void setLastTransferDate(Date aLastTransferDate) {
        this.lastTransferDate = aLastTransferDate;
    }

    void validateState() throws EPPCodecException {
        if (this.id == null) {
            throw new EPPCodecException("required attribute id is not set");
        }
        if (this.roid == null) {
            throw new EPPCodecException("required attribute roid is not set");
        }
        if (this.statuses == null) {
            throw new EPPCodecException("required attribute contact statuses is not set");
        }
        if (this.postalContacts == null || this.postalContacts.size() == 0) {
            throw new EPPCodecException("required attribute postalContacts is not set");
        }
        if (this.email == null) {
            throw new EPPCodecException("required attribute contact email is not set");
        }
        if (this.clientId == null) {
            throw new EPPCodecException("clientId required attribute is not set");
        }
        if (this.createdBy == null) {
            throw new EPPCodecException("createBy required attribute is not set");
        }
        if (this.createdDate == null) {
            throw new EPPCodecException("createdDate required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element currElm = null;
        Text currVal = null;
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPContactInfoResp.doEncode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeString(aDocument, root, this.roid, "urn:ietf:params:xml:ns:contact-1.0", ELM_ROID);
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        EPPUtil.encodeCompVector(aDocument, root, this.postalContacts);
        if (this.voice != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            currVal = aDocument.createTextNode(this.voice);
            if (this.voiceExt != null) {
                currElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        if (this.fax != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            currVal = aDocument.createTextNode(this.fax);
            if (this.faxExt != null) {
                currElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:contact-1.0", ELM_CLIENT_ID);
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_BY);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_DATE);
        EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_BY);
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_DATE);
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastTransferDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_TRANSFER_DATE);
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        EPPUtil.encodeComp(aDocument, root, this.disclose);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element currElm = null;
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.roid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_ROID);
        this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_STATUSES, EPPContactStatus.class);
        this.postalContacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_POSTAL_INFO, EPPContactPostalDefinition.class);
        this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
        if (this.voice != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            this.voiceExt = currElm.getAttribute(ATTR_EXT);
            if (this.voiceExt.length() == 0) {
                this.voiceExt = null;
            }
        } else {
            this.voiceExt = null;
        }
        this.fax = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
        if (this.fax != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            this.faxExt = currElm.getAttribute(ATTR_EXT);
            if (this.faxExt.length() == 0) {
                this.faxExt = null;
            }
        } else {
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CLIENT_ID);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_BY);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_DATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_BY);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_DATE);
        this.lastTransferDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_TRANSFER_DATE);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO, EPPAuthInfo.class);
        this.disclose = (EPPContactDisclose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_DISCLOSE, EPPContactDisclose.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactInfoResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactInfoResp theComp = (EPPContactInfoResp)aObject;
        if (!(this.id != null ? this.id.equals(theComp.id) : theComp.id == null)) {
            return false;
        }
        if (!(this.roid != null ? this.roid.equals(theComp.roid) : theComp.roid == null)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theComp.statuses)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.postalContacts, theComp.postalContacts)) {
            return false;
        }
        if (!(this.voice != null ? this.voice.equals(theComp.voice) : theComp.voice == null)) {
            return false;
        }
        if (!(this.voiceExt != null ? this.voiceExt.equals(theComp.voiceExt) : theComp.voiceExt == null)) {
            return false;
        }
        if (!(this.fax != null ? this.fax.equals(theComp.fax) : theComp.fax == null)) {
            return false;
        }
        if (!(this.faxExt != null ? this.faxExt.equals(theComp.faxExt) : theComp.faxExt == null)) {
            return false;
        }
        if (!(this.email != null ? this.email.equals(theComp.email) : theComp.email == null)) {
            return false;
        }
        if (!(this.clientId != null ? this.clientId.equals(theComp.clientId) : theComp.clientId == null)) {
            return false;
        }
        if (!(this.createdBy != null ? this.createdBy.equals(theComp.createdBy) : theComp.createdBy == null)) {
            return false;
        }
        if (!(this.createdDate != null ? this.createdDate.equals(theComp.createdDate) : theComp.createdDate == null)) {
            return false;
        }
        if (!(this.lastUpdatedBy != null ? this.lastUpdatedBy.equals(theComp.lastUpdatedBy) : theComp.lastUpdatedBy == null)) {
            return false;
        }
        if (!(this.lastUpdatedDate != null ? this.lastUpdatedDate.equals(theComp.lastUpdatedDate) : theComp.lastUpdatedDate == null)) {
            return false;
        }
        if (!(this.lastTransferDate != null ? this.lastTransferDate.equals(theComp.lastTransferDate) : theComp.lastTransferDate == null)) {
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            return false;
        }
        return this.disclose != null ? this.disclose.equals(theComp.disclose) : theComp.disclose == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPContactInfoResp clone = (EPPContactInfoResp)super.clone();
        if (this.statuses != null) {
            clone.statuses = (Vector)this.statuses.clone();
            for (i = 0; i < this.statuses.size(); ++i) {
                clone.statuses.setElementAt(((EPPContactStatus)this.statuses.elementAt(i)).clone(), i);
            }
        }
        if (this.postalContacts != null) {
            clone.postalContacts = (Vector)this.postalContacts.clone();
            for (i = 0; i < this.postalContacts.size(); ++i) {
                clone.postalContacts.setElementAt(((EPPContactPostalDefinition)this.postalContacts.elementAt(i)).clone(), i);
            }
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.disclose != null) {
            clone.disclose = (EPPContactDisclose)this.disclose.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Vector getPostalInfo() {
        return this.postalContacts;
    }

    public void setPostalInfo(Vector newPostalContacts) {
        this.postalContacts = newPostalContacts;
    }

    public void addPostalInfo(EPPContactPostalDefinition newPostalInfo) {
        EPPContactPostalDefinition aPostalInfo = null;
        if (newPostalInfo != null) {
            try {
                aPostalInfo = (EPPContactPostalDefinition)newPostalInfo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            this.postalContacts.add(newPostalInfo);
        }
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
        }
    }

    public EPPContactDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPContactDisclose newDisclose) {
        if (newDisclose != null) {
            this.disclose = newDisclose;
            this.disclose.setRootName(ELM_CONTACT_DISCLOSE);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String newEmail) {
        this.email = newEmail;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String newFax) {
        this.fax = newFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String newFaxExt) {
        this.faxExt = newFaxExt;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector newStatuses) {
        this.statuses = newStatuses;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String newVoice) {
        this.voice = newVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String newVoiceExt) {
        this.voiceExt = newVoiceExt;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String newRoid) {
        this.roid = newRoid;
    }
}

