/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPContactCreateCmd
extends EPPCreateCmd {
    static final String ELM_NAME = "contact:create";
    private static final String ELM_CONTACT_POSTAL_INFO = "contact:postalInfo";
    private static final String ELM_CONTACT_AUTHINFO = "contact:authInfo";
    private static final String ELM_CONTACT_EMAIL = "contact:email";
    private static final String ELM_CONTACT_FAX = "contact:fax";
    private static final String ELM_CONTACT_ID = "contact:id";
    private static final String ELM_CONTACT_VOICE = "contact:voice";
    private static final String ELM_CONTACT_DISCLOSE = "contact:disclose";
    private static final String ATTR_EXT = "x";
    private Vector postalContacts = new Vector();
    private EPPAuthInfo authInfo = null;
    private EPPContactDisclose disclose = null;
    private String email = null;
    private String fax = null;
    private String faxExt = null;
    private String id = null;
    private String voice = null;
    private String voiceExt = null;

    public EPPContactCreateCmd() {
    }

    public EPPContactCreateCmd(String aTransId) {
        super(aTransId);
    }

    public EPPContactCreateCmd(String aTransId, String aId, EPPContactPostalDefinition aPostalContact, String aEmail, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.id = aId;
        this.postalContacts.add(aPostalContact);
        this.voice = null;
        this.fax = null;
        this.email = aEmail;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.id == null) {
            throw new EPPCodecException("required attribute contact id is not set");
        }
        if (this.postalContacts == null || this.postalContacts.size() == 0) {
            throw new EPPCodecException("required attribute contact postalInfo is not set");
        }
        if (this.email == null) {
            throw new EPPCodecException("required attribute contact email is not set");
        }
        if (this.authInfo == null) {
            throw new EPPCodecException("required attribute contact authInfo is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element currElm = null;
        Text currVal = null;
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeCompVector(aDocument, root, this.postalContacts);
        if (this.voice != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            currVal = aDocument.createTextNode(this.voice);
            if (this.voiceExt != null) {
                currElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        if (this.fax != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            currVal = aDocument.createTextNode(this.fax);
            if (this.faxExt != null) {
                currElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        EPPUtil.encodeComp(aDocument, root, this.disclose);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element currElm = null;
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.postalContacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_POSTAL_INFO, EPPContactPostalDefinition.class);
        this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
        if (this.voice != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            this.voiceExt = currElm.getAttribute(ATTR_EXT);
            if (this.voiceExt.length() == 0) {
                this.voiceExt = null;
            }
        } else {
            this.voiceExt = null;
        }
        this.fax = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
        if (this.fax != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            this.faxExt = currElm.getAttribute(ATTR_EXT);
            if (this.faxExt.length() == 0) {
                this.faxExt = null;
            }
        } else {
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO, EPPAuthInfo.class);
        this.disclose = (EPPContactDisclose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_DISCLOSE, EPPContactDisclose.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactCreateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactCreateCmd theComp = (EPPContactCreateCmd)aObject;
        if (!(this.id != null ? this.id.equals(theComp.id) : theComp.id == null)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.postalContacts, theComp.postalContacts)) {
            return false;
        }
        if (!(this.voice != null ? this.voice.equals(theComp.voice) : theComp.voice == null)) {
            return false;
        }
        if (!(this.voiceExt != null ? this.voiceExt.equals(theComp.voiceExt) : theComp.voiceExt == null)) {
            return false;
        }
        if (!(this.fax != null ? this.fax.equals(theComp.fax) : theComp.fax == null)) {
            return false;
        }
        if (!(this.faxExt != null ? this.faxExt.equals(theComp.faxExt) : theComp.faxExt == null)) {
            return false;
        }
        if (!(this.email != null ? this.email.equals(theComp.email) : theComp.email == null)) {
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            return false;
        }
        return this.disclose != null ? this.disclose.equals(theComp.disclose) : theComp.disclose == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactCreateCmd clone = (EPPContactCreateCmd)super.clone();
        if (this.postalContacts != null) {
            clone.postalContacts = (Vector)this.postalContacts.clone();
            for (int i = 0; i < this.postalContacts.size(); ++i) {
                clone.postalContacts.setElementAt(((EPPContactPostalDefinition)this.postalContacts.elementAt(i)).clone(), i);
            }
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.disclose != null) {
            clone.disclose = (EPPContactDisclose)this.disclose.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Vector getPostalInfo() {
        return this.postalContacts;
    }

    public void setPostalInfo(Vector newPostalContacts) {
        this.postalContacts = newPostalContacts;
    }

    public void addPostalInfo(EPPContactPostalDefinition newPostalInfo) {
        EPPContactPostalDefinition aPostalContact = null;
        if (newPostalInfo != null) {
            try {
                aPostalContact = (EPPContactPostalDefinition)newPostalInfo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            this.postalContacts.add(newPostalInfo);
        }
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public EPPContactDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPContactDisclose newDisclose) {
        if (newDisclose != null) {
            this.disclose = newDisclose;
            this.disclose.setRootName(ELM_CONTACT_DISCLOSE);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public String getFax() {
        return this.fax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public String getId() {
        return this.id;
    }

    public String getVoice() {
        return this.voice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
        }
    }

    public void setEmail(String newEmail) {
        this.email = newEmail;
    }

    public void setFax(String newFax) {
        this.fax = newFax;
    }

    public void setFaxExt(String newFaxExt) {
        this.faxExt = newFaxExt;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void setVoice(String newVoice) {
        this.voice = newVoice;
    }

    public void setVoiceExt(String newVoiceExt) {
        this.voiceExt = newVoiceExt;
    }
}

