/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.coaext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPCoaExtKey
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = Logger.getLogger((String)EPPCoaExtKey.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "coa:key";
    private String key;

    public EPPCoaExtKey() {
    }

    public EPPCoaExtKey(String aKey) {
        this.key = aKey;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCoaExtKey clone = null;
        clone = (EPPCoaExtKey)super.clone();
        clone.setKey(this.getKey());
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPCoaExtKey.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPCoaExtKey.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPCoaExtKey invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:coa-1.0", ELM_NAME);
        Text keyText = aDocument.createTextNode(this.key);
        root.appendChild(keyText);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement != null) {
            Text keyText = (Text)aElement.getFirstChild();
            this.key = keyText == null ? null : keyText.getData();
        }
    }

    void validateState() throws EPPCodecException {
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPCoaExtKey)) {
            return false;
        }
        EPPCoaExtKey theComp = (EPPCoaExtKey)aObject;
        return this.key.equalsIgnoreCase(theComp.getKey());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }
}

