/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

final class ImportPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ImportPrinter();
    private static final String DELIMETER = "|";

    protected ImportPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, true, out);
        this.trackPosition((JavaNode)node, out);
        out.print("import ", 56);
        AST identifier = node.getFirstChild();
        String name = JavaNodeHelper.getDottedName(identifier);
        out.print(name, 56);
        AST semi = identifier.getNextSibling();
        PrinterFactory.create(semi).print(semi, out);
        AST next = node.getNextSibling();
        if (next != null) {
            switch (next.getType()) {
                case 34: {
                    if (!settings.getBoolean(ConventionKeys.IMPORT_SORT, true)) break;
                    String nextName = JavaNodeHelper.getDottedName(next.getFirstChild());
                    int depth = this.getImportDepth(name);
                    int offset = StringHelper.indexOf('.', name, depth);
                    if (offset > -1) {
                        String nextPart = name.substring(0, offset);
                        if (nextName.startsWith(nextPart + '.')) break;
                        this.printNewline(next, out);
                        break;
                    }
                    if (depth <= 0) break;
                    int dots = StringHelper.occurs('.', name);
                    if (dots > 0) {
                        String nextPart = name.substring(0, name.lastIndexOf(46));
                        if (nextName.startsWith(nextPart + '.') && StringHelper.occurs('.', nextName) == dots) break;
                        this.printNewline(next, out);
                        break;
                    }
                    if (nextName.indexOf(46) <= -1) break;
                    this.printNewline(next, out);
                }
            }
        }
        out.last = 34;
    }

    private int getImportDepth(String declaration) {
        String info;
        int defaultGroupingDepth = settings.getInt(ConventionKeys.IMPORT_GROUPING_DEPTH, 3);
        if (defaultGroupingDepth > 0 && (info = settings.get(ConventionKeys.IMPORT_GROUPING, "*:0|gnu:2|java:2|javax:2")).length() > 0) {
            Map values = this.decodeGroupingInfo(info);
            Iterator i = values.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!declaration.startsWith((String)entry.getKey())) continue;
                return new Integer((String)entry.getValue());
            }
        }
        return defaultGroupingDepth;
    }

    private Map decodeGroupingInfo(String info) {
        HashMap<String, String> result = new HashMap<String, String>(15);
        StringTokenizer tokens = new StringTokenizer(info, DELIMETER);
        while (tokens.hasMoreElements()) {
            String pair = tokens.nextToken();
            int delimOffset = pair.indexOf(58);
            String name = pair.substring(0, delimOffset);
            String depth = pair.substring(delimOffset + 1);
            result.put(name, depth);
        }
        return result;
    }

    private void printNewline(AST node, NodeWriter out) throws IOException {
        JavaNode n = (JavaNode)node;
        CommonHiddenStreamToken comment = n.getHiddenBefore();
        if (comment == null || node.getType() != 34) {
            out.printNewline();
        } else {
            switch (comment.getType()) {
                case 155: {
                    if (settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE, 1) > 0) break;
                    out.printNewline();
                    break;
                }
                case 6: {
                    if (settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_JAVADOC, 1) > 0) break;
                    out.printNewline();
                    break;
                }
                case 157: {
                    if (settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_MULTI_LINE, 1) > 0) break;
                    out.printNewline();
                    break;
                }
            }
        }
    }
}

