/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.contact.EPPContactCheckCmd;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactDeleteCmd;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactMapFactory;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPContactHandler
implements EPPEventHandler {
    private static final String NS = "urn:ietf:params:xml:ns:contact-1.0";
    private static final Logger cat = Logger.getLogger((String)EPPContactHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPContactHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPContactMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the Contact Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPContactCreateCmd) {
            response = this.doContactCreate(aEvent, aData);
        } else if (message instanceof EPPContactDeleteCmd) {
            response = this.doContactDelete(aEvent, aData);
        } else if (message instanceof EPPContactInfoCmd) {
            response = this.doContactInfo(aEvent, aData);
        } else if (message instanceof EPPContactCheckCmd) {
            response = this.doContactCheck(aEvent, aData);
        } else if (message instanceof EPPContactTransferCmd) {
            response = this.doContactTransfer(aEvent, aData);
        } else if (message instanceof EPPContactUpdateCmd) {
            response = this.doContactUpdate(aEvent, aData);
        } else {
            throw new EPPEventException("In EPPDomainHandler an event was sent that is not supported");
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doContactCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doContactDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doContactInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doContactCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doContactTransfer(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doContactUpdate(EPPEvent var1, Object var2);
}

