/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.resellerext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPResellerExtUpdate
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPResellerExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "resellerext:update";
    private static final String ELM_RESELLER_ID = "id";
    private Action action;
    private String resellerId;

    public EPPResellerExtUpdate() {
    }

    public EPPResellerExtUpdate(Action aAction, String aResellerId) {
        this.setAction(aAction);
        this.setResellerId(aResellerId);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action aAction) {
        this.action = aAction;
    }

    public String getResellerId() {
        return this.resellerId;
    }

    public void setResellerId(String aResellerId) {
        this.resellerId = aResellerId;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.action == null) {
            throw new EPPEncodeException("Undefined action in EPPResellerExtUpdate");
        }
        if (this.resellerId == null) {
            throw new EPPEncodeException("Undefined resellerId in EPPResellerExtUpdate");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:resellerext-1.0", ELM_NAME);
        Element action = aDocument.createElementNS("urn:ietf:params:xml:ns:resellerext-1.0", "resellerext:" + (Object)((Object)this.action));
        root.appendChild(action);
        EPPUtil.encodeString(aDocument, action, this.resellerId, "urn:ietf:params:xml:ns:resellerext-1.0", "resellerext:id");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element actionElm = EPPUtil.getFirstElementChild(aElement);
        if (actionElm == null) {
            throw new EPPDecodeException("Action element not found");
        }
        this.action = Action.getAction(actionElm.getLocalName());
        this.resellerId = EPPUtil.decodeString(actionElm, "urn:ietf:params:xml:ns:resellerext-1.0", ELM_RESELLER_ID);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerExtUpdate clone = (EPPResellerExtUpdate)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerExtUpdate)) {
            return false;
        }
        EPPResellerExtUpdate other = (EPPResellerExtUpdate)aObject;
        if (!EqualityUtil.equals((Object)this.action, (Object)other.action)) {
            cat.error((Object)"EPPResellerExtUpdate.equals(): action not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.resellerId, other.resellerId)) {
            cat.error((Object)"EPPResellerExtUpdate.equals(): resellerId not equal");
            return false;
        }
        return true;
    }

    public static enum Action {
        ADD("add"),
        REM("rem"),
        CHG("chg");

        private final String localElm;

        private Action(String aLocalElm) {
            this.localElm = aLocalElm;
        }

        public static Action getAction(String aLocalElm) {
            if (aLocalElm == null || aLocalElm.isEmpty()) {
                throw new InvalidParameterException("Action null or empty enum value of is not valid.");
            }
            if (aLocalElm.equals(Action.ADD.localElm)) {
                return ADD;
            }
            if (aLocalElm.equals(Action.REM.localElm)) {
                return REM;
            }
            if (aLocalElm.equals(Action.CHG.localElm)) {
                return CHG;
            }
            throw new InvalidParameterException("Action enum value of " + aLocalElm + " is not valid.");
        }

        public String toString() {
            return this.localElm;
        }
    }
}

