/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPResellerContact
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPResellerContact.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "contact";
    public static final String ELM_NAME = "reseller:contact";
    private static final String ATTR_TYPE = "type";
    private Type type;
    private String contactId;

    public EPPResellerContact() {
    }

    public EPPResellerContact(String aContactId, Type aType) {
        this.contactId = aContactId;
        this.type = aType;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType;
    }

    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String aContactId) {
        this.contactId = aContactId;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", ELM_NAME);
        if (this.type == null) {
            throw new EPPEncodeException("EPPResellerContact type is null on call to encode");
        }
        if (this.contactId == null) {
            throw new EPPEncodeException("EPPResellerContact contactId is null on call to encode");
        }
        root.setAttribute(ATTR_TYPE, this.type.toString());
        Text textNode = aDocument.createTextNode(this.contactId);
        root.appendChild(textNode);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = Type.getType(aElement.getAttribute(ATTR_TYPE));
        this.contactId = aElement.getFirstChild().getNodeValue();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerContact)) {
            return false;
        }
        EPPResellerContact theComp = (EPPResellerContact)aObject;
        if (!EqualityUtil.equals(this.contactId, theComp.contactId)) {
            cat.error((Object)"EPPResellerContact.equals(): contactId not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.type, (Object)theComp.type)) {
            cat.error((Object)"EPPResellerContact.equals(): type not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerContact clone = null;
        clone = (EPPResellerContact)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum Type {
        ADMINISTRATIVE("admin"),
        TECHNICAL("tech"),
        BILLING("billing");

        private final String typeVal;

        private Type(String aTypeVal) {
            this.typeVal = aTypeVal;
        }

        public static Type getType(String aTypeVal) {
            if (aTypeVal == null || aTypeVal.isEmpty()) {
                throw new InvalidParameterException("Type value of null or empty is not valid.");
            }
            if (aTypeVal.equals(Type.ADMINISTRATIVE.typeVal)) {
                return ADMINISTRATIVE;
            }
            if (aTypeVal.equals(Type.TECHNICAL.typeVal)) {
                return TECHNICAL;
            }
            if (aTypeVal.equals(Type.BILLING.typeVal)) {
                return BILLING;
            }
            throw new InvalidParameterException("Type enum value of " + aTypeVal + " is not valid.");
        }

        public String toString() {
            return this.typeVal;
        }
    }
}

