/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPResellerCheckCmd
extends EPPCheckCmd {
    private static Logger cat = Logger.getLogger((String)EPPResellerCheckCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "reseller:check";
    private static final String ELM_RESELLER_ID = "id";
    private List<String> resellerIds = new ArrayList<String>();

    public EPPResellerCheckCmd() {
    }

    public EPPResellerCheckCmd(String aTransId) {
        super(aTransId);
    }

    public EPPResellerCheckCmd(String aTransId, String aResellerId) {
        super(aTransId);
        this.addResellerId(aResellerId);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:reseller-1.0";
    }

    public boolean hasResellerIds() {
        return this.resellerIds != null && !this.resellerIds.isEmpty();
    }

    public List<String> getResellerIds() {
        return this.resellerIds;
    }

    public void setResellerIds(List<String> aResellerIds) {
        if (aResellerIds == null) {
            this.resellerIds = new ArrayList<String>();
        }
        this.resellerIds = aResellerIds;
    }

    public void setResellerId(String aResellerId) {
        this.resellerIds = new ArrayList<String>();
        this.resellerIds.add(aResellerId);
    }

    public void addResellerId(String aResellerId) {
        this.resellerIds.add(aResellerId);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (!this.hasResellerIds()) {
            throw new EPPEncodeException("At least one reseller identifier is needed with EPPResellerCheckCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.resellerIds, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:id");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.resellerIds = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_ID);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPResellerCheckCmd theMap = (EPPResellerCheckCmd)aObject;
        if (!EPPUtil.equalLists(this.resellerIds, theMap.resellerIds)) {
            cat.error((Object)"EPPResellerCheckCmd.equals(): resellerIds not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerCheckCmd clone = (EPPResellerCheckCmd)super.clone();
        clone.resellerIds = (List)((ArrayList)this.resellerIds).clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

