/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v09;

import com.verisign.epp.codec.fee.v09.EPPFeeCommand;
import com.verisign.epp.codec.fee.v09.EPPFeePeriod;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPFeeObject
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "object";
    public static final String ELM_NAME = "fee:object";
    public static final String DEFAULT_OBJ_URI = "urn:ietf:params:xml:ns:domain-1.0";
    public static final String DEFAULT_OBJ_ELEMENT = "name";
    private static Logger cat = Logger.getLogger((String)EPPFeeObject.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String objURI = "urn:ietf:params:xml:ns:domain-1.0";
    private static final String ELM_OBJ_ID = "objID";
    private static final String ELM_CURRENCY = "currency";
    private static final String ATTR_OBJ_URI = "objURI";
    private static final String ATTR_OBJ_ELEMENT = "element";
    private String objID;
    private String objElement = "name";
    private String currency;
    private EPPFeeCommand command;
    private EPPFeePeriod period;

    public EPPFeeObject() {
    }

    public EPPFeeObject(String aObjID, EPPFeeCommand aCommand) {
        this.setObjID(aObjID);
        this.setCommand(aCommand);
    }

    public EPPFeeObject(String aObjID, String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod) {
        this.setObjID(aObjID);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
    }

    public EPPFeeObject(String aObjID, String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, String aObjURI, String aObjElement) {
        this.setObjID(aObjID);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.setObjURI(aObjURI);
        this.setObjElement(aObjElement);
    }

    public String getObjID() {
        return this.objID;
    }

    public void setObjID(String aObjID) {
        this.objID = aObjID;
    }

    public boolean hasCurrency() {
        return this.currency != null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public EPPFeeCommand getCommand() {
        return this.command;
    }

    public void setCommand(EPPFeeCommand aCommand) {
        this.command = aCommand;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    public String getObjURI() {
        return this.objURI;
    }

    public void setObjURI(String aObjURI) {
        this.objURI = aObjURI;
    }

    public String getObjElement() {
        return this.objElement;
    }

    public void setObjElement(String aObjElement) {
        this.objElement = aObjElement;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeObject.encode(Document)");
        }
        if (this.objID == null) {
            throw new EPPEncodeException("Required objID attribute is null in EPPFeeObject.encode(Document).");
        }
        if (this.command == null) {
            throw new EPPEncodeException("Required command attribute is null in EPPFeeObject.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.9", ELM_NAME);
        if (this.objURI != null) {
            root.setAttribute(ATTR_OBJ_URI, this.objURI);
        }
        Element theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.9", "fee:objID");
        Text theVal = aDocument.createTextNode(this.objID);
        theElm.appendChild(theVal);
        root.appendChild(theElm);
        if (this.objElement != null) {
            theElm.setAttribute(ATTR_OBJ_ELEMENT, this.objElement);
        }
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.9", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.command);
        EPPUtil.encodeComp(aDocument, root, this.period);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.objURI = aElement.getAttribute(ATTR_OBJ_URI);
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_OBJ_ID);
        if (theElm != null) {
            this.objID = EPPUtil.decodeStringValue(theElm);
            this.objElement = theElm.getAttribute(ATTR_OBJ_ELEMENT);
        }
        this.objID = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_OBJ_ID);
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_CURRENCY);
        if (this.currency != null && this.currency.isEmpty()) {
            this.currency = null;
        }
        this.command = (EPPFeeCommand)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.9", "fee:command", EPPFeeCommand.class);
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.9", "fee:period", EPPFeePeriod.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeObject clone = (EPPFeeObject)super.clone();
        clone.objURI = this.objURI;
        clone.objID = this.objID;
        clone.objElement = this.objElement;
        clone.currency = this.currency;
        clone.command = this.command == null ? null : (EPPFeeCommand)this.command.clone();
        clone.period = this.period == null ? null : (EPPFeePeriod)this.period.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeObject)) {
            cat.error((Object)("EPPFeeObject.equals(): " + aObject.getClass().getName() + " not EPPFeeObject instance"));
            return false;
        }
        EPPFeeObject other = (EPPFeeObject)aObject;
        if (!EqualityUtil.equals(this.objURI, other.objURI)) {
            cat.error((Object)"EPPFeeObject.equals(): objURI not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.objID, other.objID)) {
            cat.error((Object)"EPPFeeObject.equals(): objID not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.objElement, other.objElement)) {
            cat.error((Object)"EPPFeeObject.equals(): objElement not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeObject.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeObject.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeObject.equals(): period not equal");
            return false;
        }
        return true;
    }
}

