/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v06;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeCredit
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPFeeCredit.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "credit";
    public static final String ELM_NAME = "fee:credit";
    private static final String ATTR_DESCRIPTION = "description";
    private String description;
    private BigDecimal credit;

    public EPPFeeCredit() {
    }

    public EPPFeeCredit(BigDecimal aCredit) {
        this.setCredit(aCredit);
    }

    public EPPFeeCredit(BigDecimal aCredit, String aDescription) {
        this.setCredit(aCredit);
        this.setDescription(aDescription);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
        cat.debug((Object)("setDescription: description = " + this.description));
    }

    public BigDecimal getCredit() {
        return this.credit;
    }

    public void setCredit(BigDecimal aCredit) {
        if (aCredit != null) {
            this.credit = aCredit;
            this.credit.setScale(2, 4);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCredit clone = null;
        clone = (EPPFeeCredit)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theDescription = aElement.getAttribute(ATTR_DESCRIPTION);
        this.description = theDescription != null && !theDescription.isEmpty() ? theDescription : null;
        this.credit = EPPUtil.decodeBigDecimal(aElement);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeCredit.encode(Document)");
        }
        if (this.credit == null) {
            throw new EPPEncodeException("fee is null on in EPPFeeCredit.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.6", ELM_NAME);
        if (this.description != null) {
            root.setAttribute(ATTR_DESCRIPTION, this.description);
        }
        EPPUtil.encodeBigDecimal(aDocument, root, this.credit, null);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCredit)) {
            return false;
        }
        EPPFeeCredit other = (EPPFeeCredit)aObject;
        if (!EqualityUtil.equals(this.description, other.description)) {
            cat.error((Object)"EPPFeeCredit.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.credit, other.credit)) {
            cat.error((Object)"EPPFeeCredit.equals(): credit not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

